﻿---
title: Effective issue reporting in Kibana
description: We seriously appreciate thoughtful comments. If an issue is important to you, add a comment with a solid write up of your use case and explain why it’s...
url: https://www.elastic.co/docs/extend/kibana/kibana-issue-reporting
products:
  - Kibana
---

# Effective issue reporting in Kibana
## Voicing the importance of an issue

We seriously appreciate thoughtful comments. If an issue is important to you, add a comment with a solid write up of your use case and explain why it’s so important. Please avoid posting comments comprised solely of a thumbs up emoji 👍.
Granted that you share your thoughts, we might even be able to come up with creative solutions to your specific problem. If everything you’d like to say has already been brought up but you’d still like to add a token of support, feel free to add a [👍 thumbs up reaction](https://github.com/blog/2119-add-reactions-to-pull-requests-issues-and-comments) on the issue itself and on the comment which best summarizes your thoughts.

## "`My issue isn’t getting enough attention`"

First of all, **sorry about that!** We want you to have a great time with Kibana.
There’s hundreds of open issues and prioritizing what to work on is an important aspect of our daily jobs. We prioritize issues according to impact and difficulty, so some issues can be neglected while we work on more pressing issues.
Feel free to bump your issues if you think they’ve been neglected for a prolonged period.

## "`I want to help!`"

**Now we’re talking**. If you have a bug fix or new feature that you would like to contribute to Kibana, please **find or open an issue about it before you start working on it.** Talk about what you would like to do. It may be that somebody is already working on it, or that there are particular issues that you should know about before implementing the change.
We enjoy working with contributors to get their code accepted. There are many approaches to fixing a problem and it is important to find the best approach before writing too much code.