﻿---
title: Architecture
description: To begin plugin development, we recommend reading our overview of how plugins work: Kibana Plugin API. Our developer services are changing all the time...
url: https://www.elastic.co/docs/extend/kibana/kibana-architecture
products:
  - Kibana
---

# Architecture
<important>
  The Kibana Plugin APIs are in a state of constant development. We cannot provide backwards compatibility at this time due to the high rate of change.
</important>

To begin plugin development, we recommend reading our overview of how plugins work:
- [Kibana Plugin API](https://www.elastic.co/docs/extend/kibana/kibana-platform-plugin-api)

Our developer services are changing all the time. One of the best ways to discover and learn about them is to read the available READMEs inside our plugins folders: [src/plugins](https://github.com/elastic/kibana/tree/master/src/plugins) and [x-pack/plugins](https://github.com/elastic/kibana/tree/master/x-pack/plugins).
A few services also automatically generate api documentation which can be browsed inside the [docs/development section of our repo](https://github.com/elastic/kibana/tree/master/docs/development)
A few notable services are called out below.
- [Kibana Core API](https://www.elastic.co/docs/extend/kibana/kibana-platform-api)
- [Security](https://www.elastic.co/docs/extend/kibana/development-security)
- [Add data tutorials](https://www.elastic.co/docs/extend/kibana/add-data-tutorials)
- [Developing Visualizations](https://www.elastic.co/docs/extend/kibana/development-visualize-index)
- [Reporting integration](https://www.elastic.co/docs/extend/kibana/reporting-integration)