﻿---
title: External plugin development
description: Most developers who contribute code directly to the Kibana repo are writing code inside plugins, so our Contributing docs are the best place to start...
url: https://www.elastic.co/docs/extend/kibana/external-plugin-development
products:
  - Kibana
---

# External plugin development
<important>
  The Kibana plugin interfaces are in a state of constant development.  We cannot provide backwards compatibility for plugins due to the high rate of change.  Kibana enforces that the installed plugins match the version of Kibana itself.  Plugin developers will have to release a new version of their plugin for each new Kibana release as a result.
</important>

Most developers who contribute code directly to the Kibana repo are writing code inside plugins, so our [*Contributing*](https://www.elastic.co/docs/extend/kibana/contributing) docs are the best place to start. However, there are a few differences when developing plugins outside the Kibana repo. These differences are covered here.
- [Plugin tooling](https://www.elastic.co/docs/extend/kibana/plugin-tooling)
- [Functional Tests for Plugins outside the Kibana repo](https://www.elastic.co/docs/extend/kibana/external-plugin-functional-tests)
- [Localization for plugins outside the Kibana repo](https://www.elastic.co/docs/extend/kibana/external-plugin-localization)
- [Testing Kibana Plugins](https://www.elastic.co/docs/extend/kibana/testing-kibana-plugin)