﻿---
title: Considerations for basepath
description: In dev mode, Kibana by default runs behind a proxy which adds a random path component to its URL. You can set this explicitly using server.basePath. This...
url: https://www.elastic.co/docs/extend/kibana/development-basepath
products:
  - Kibana
---

# Considerations for basepath
In dev mode, Kibana by default runs behind a proxy which adds a random path component to its URL.
You can set this explicitly using [`server.basePath`](/docs/reference/kibana/configuration-reference/general-settings#server-basePath). This setting cannot end in a slash (/).
Use [`server.rewriteBasePath`](/docs/reference/kibana/configuration-reference/general-settings#server-rewriteBasePath) to tell Kibana if it should remove the basePath from requests it receives, and to prevent a deprecation warning at startup.
If you want to turn off the basepath when in development mode, start Kibana with the `--no-base-path` flag
```bash
yarn start --no-base-path
```