﻿---
title: Application service
description: Kibana has migrated to be a Single Page Application. Plugins should use Application service API to instruct Kibana that an application should be loaded...
url: https://www.elastic.co/docs/extend/kibana/application-service
products:
  - Kibana
---

# Application service
Kibana has migrated to be a Single Page Application. Plugins should use `Application service` API to instruct Kibana that an application should be loaded and rendered in the UI in response to user interactions. The service also provides utilities for controlling the navigation link state, seamlessly integrating routing between applications, and loading async chunks on demand.
<note>
  The Application service is only available client side.
</note>

```typescript
import { AppMountParameters, CoreSetup, Plugin, DEFAULT_APP_CATEGORIES } from '@kbn/core/public';

export class MyPlugin implements Plugin {
  public setup(core: CoreSetup) {
    core.application.register({ 
      category: DEFAULT_APP_CATEGORIES.kibana,
      id: 'my-plugin',
      title: 'my plugin title',
      euiIconType: '/path/to/some.svg',
      order: 100,
      appRoute: '/app/my_plugin', 
      async mount(params: AppMountParameters) { 
        // Load application bundle
        const { renderApp } = await import('./application');
        // Get start services
        const [coreStart, depsStart] = await core.getStartServices(); 
        // Render the application
        return renderApp(coreStart, depsStart, params); 
      },
    });
  }
}
```

<note>
  you are free to use any UI library to render a plugin application in DOM. However, we recommend using React and [EUI](https://elastic.github.io/eui) for all your basic UI components to create a consistent UI experience.
</note>