﻿---
title: What is an integration?
description: An Elastic integration is a collection of assets that defines how to observe a specific product or service with the Elastic Stack: Data ingest, storage,...
url: https://www.elastic.co/docs/extend/integrations/what-is-an-integration
products:
  - Elastic integrations
---

# What is an integration?
An Elastic integration is a collection of assets that defines how to observe a specific product or service with the Elastic Stack:
- Data ingest, storage, and transformation rules
- Configuration options
- Pre-built, custom dashboards and visualizations
- Documentation
- Tests

Integrations have a strict, well-defined structure, and offer a number of benefits over other ingest options:
- Structured around the service that is being observed— not the monitoring agent
- Easy, less error-prone configuration
- Fewer monitoring agents for users to install
- Deploy in just a few clicks
- Decoupled release process from the Elastic Stack


## Integration lifecycle

1. Create a source package
   All integrations start as a source package. You’ll find most Elastic integrations in the [`elastic/integrations`](https://github.com/elastic/integrations) repository, but a package can live anywhere.
   All packages must adhere to the [package specification](https://www.elastic.co/docs/extend/integrations/package-spec)—a formal spec used for the creation and validation of new or updated integrations.
2. Publish the integration to the package registry
   Once an integration (package) has been created, it needs to be built. Built integrations are served up via the [Elastic Package Registry](https://github.com/elastic/package-registry). The Fleet UI in Kibana connects to the Elastic Package Registry and allows users to discover, install, and configure Elastic Packages. The Elastic Package Registry can also be [deployed on-premise in air-gapped environments](https://www.elastic.co/docs/reference/fleet/air-gapped#air-gapped-diy-epr).
3. Install the integration
   Using Fleet in Kibana, install the integration and add it to an Elastic Agent policy. When you install a package, its assets are unpacked and installed into Elasticsearch and Kibana using Elastic Stack APIs. In addition, configuration for the package is persisted in Elasticsearch as an Elastic Agent policy.
4. Add the policy with the integration to an Elastic Agent.
   Once the policy with an integration is added to an Elastic Agent, the Elastic Agent will begin to collect and ship data to the Elastic Stack based on the Elastic integration.
   Package assets may come into play here. For example, if a package installed ingest pipelines, those will intercept the data and transform it before it is indexed.
5. Visualize the results
   Integrations can and should ship with custom dashboards and visualizations that are installed with the integration. Use these for a tailored view of your Observability data.