﻿---
title: Finishing touches
description: Tips for manifest files: Descriptions of configuration options should be as short as possible.Remember to keep only the meaningful information about the...
url: https://www.elastic.co/docs/extend/integrations/finishing-touches
products:
  - Elastic integrations
---

# Finishing touches
## Words

Tips for manifest files:
- Descriptions of configuration options should be as short as possible.
  Remember to keep only the meaningful information about the configuration option.
  - Good candidates: references to the product configuration, accepted string values, explanation.
- Bad candidates: Collect metrics from A, B, C, D,… X, Y, Z datasets.
- Descriptions should be human readable.
  Try to rephrase sentences like: Collect foo_Bar3 metrics, into Collect Foo Bar metrics.
- Descriptions should be easy to understand.
  Simplify sentences, don’t provide information about the input if not required.
  - Bad candidate: Collect application logs (log input)
- Good candidates: Collect application logs, Collect standard logs for the application


## Add an icon

The integration icons are displayed in different places in Kibana, hence it’s better to define custom icons to make the UI easier to navigate.

## Add screenshots

The Kibana Integration Manager shows screenshots related to the integration. Screenshots include Kibana dashboards visualizing the metric and log data.

## Create a README file

The README template is used to render the final README file, including exported fields. The template should be located in the `package/<integration-name>/_dev/build/docs/README.md`. The template will include guidance on the structure and content expected for the integration.
To see how to use template functions, for example {{fields "data-stream-name"}}, review the MySQL docs template. If the same data stream name is used in both metrics and logs, please add -metrics and -logs in the template. For example, ELB is a data stream for log and also a data stream for metrics. In README.md template, {{fields "elb_logs"}} and {{fields "elb_metrics"}} are used to separate them.

## Review artifacts


## Define variable properties

The variable properties customize visualization of configuration options in the Kibana UI. Make sure they’re defined in all manifest files.
```yaml
vars:
  - name: paths
    required: true 
    show_user: true 
    title: Access log paths 
    description: Paths to the apache access log file. 
    type: text 
    multi: true 
    hide_in_deployment_modes: 
      - agentless
    default:
      - /var/log/httpd/access.log*
```