﻿---
title: Overview and prerequisites
description: Before building an integration, you should have an understanding of the following Elastic Stack concepts: Data streams: Logic abstraction for time-series...
url: https://www.elastic.co/docs/extend/integrations/build-overview
products:
  - Elastic integrations
---

# Overview and prerequisites
## Understand Elastic Stack concepts

Before building an integration, you should have an understanding of the following Elastic Stack concepts:
- [Data streams](https://www.elastic.co/docs/manage-data/data-store/data-streams): Logic abstraction for time-series data.
- [Ingest pipelines](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines): Preprocessing and enrichment of incoming data.
- [Mappings](https://www.elastic.co/docs/manage-data/data-store/mapping): Define the structure and types of your data.
- [Package specification](https://www.elastic.co/docs/extend/integrations/package-spec) to understand the required structure and fields for your integration package.


## Set up your development environment

- Install the [`elastic-package`](https://www.elastic.co/docs/extend/integrations/elastic-package) CLI tool. Using `elastic-package` is recommended for integration maintainers as it provides crucial utilities and scripts for building out integrations.
- Clone the [integrations repository](https://github.com/elastic/integrations) if you plan to contribute to official packages.