﻿---
title: Build an integration
description: Ready to monitor, ingest, and visualize something? Let’s get started. You’ll build an integration package that defines how data is collected, processed,...
url: https://www.elastic.co/docs/extend/integrations/build-new-integration
products:
  - Elastic integrations
---

# Build an integration
Ready to monitor, ingest, and visualize something? Let’s get started. You’ll build an integration package that defines how data is collected, processed, and presented.
- [Overview and prerequisites](https://www.elastic.co/docs/extend/integrations/build-overview): Get familiar with Elastic Stack fundamentals, including data streams, ingest pipelines, and field mappings, and review what you need before starting.
- [Spin up the Elastic Stack](https://www.elastic.co/docs/extend/integrations/build-spin-stack): Set up and launch your local Elastic Stack environment for development and testing.
- [Create a new package](https://www.elastic.co/docs/extend/integrations/build-create-package): Scaffold a new integration package using the elastic-package CLI, establishing the required directory structure and manifest files.
- [Add a data stream](https://www.elastic.co/docs/extend/integrations/add-data-stream): Define a new data stream to specify how your integration will collect and organize time-series data.
- [Define deployment modes](https://www.elastic.co/docs/extend/integrations/define-deployment-modes): Configure how your integration can be deployed, such as agent-based or agentless modes.
- [Edit ingest pipelines](https://www.elastic.co/docs/extend/integrations/edit-ingest-pipeline): Customize ingest pipelines to parse, enrich, and transform incoming data before it’s indexed.
- [Edit field mappings](https://www.elastic.co/docs/extend/integrations/add-mapping): Specify and adjust field mappings to define the structure and types of your indexed data.
- [Create and export dashboards](https://www.elastic.co/docs/extend/integrations/create-dashboards): Build Kibana dashboards and visualizations to explore and analyze the ingested data.
- [Enable automatic installation for content packages](https://www.elastic.co/docs/extend/integrations/auto-install-content-packages): Enable automatic installation for your content package if data with a matching dataset is ingested in Elasticsearch.
- [Testing and validation](https://www.elastic.co/docs/extend/integrations/testing-validation): Run tests and validate your integration to ensure it works as expected and meets quality standards.
- [Finishing touches](https://www.elastic.co/docs/extend/integrations/finishing-touches): Finalize documentation, metadata, and package details to prepare your integration for release.
- [Tips for building integrations](https://www.elastic.co/docs/extend/integrations/tips-for-building): Explore best practices and helpful advice to streamline your integration development process.

<tip>
  Familiar with the Elastic Stack and just want a quick way to get started? See [*Quick start: Sample integration*](https://www.elastic.co/docs/extend/integrations/quick-start).
</tip>