﻿---
title: Creating New Kibana Dashboards for a Beat or a Beat module
description: When contributing to Beats development, you may want to add new dashboards or customize the existing ones. To get started, you can import the Kibana dashboards...
url: https://www.elastic.co/docs/extend/beats/new-dashboards
products:
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Creating New Kibana Dashboards for a Beat or a Beat module
When contributing to Beats development, you may want to add new dashboards or customize the existing ones. To get started, you can [import the Kibana dashboards](https://www.elastic.co/docs/extend/beats/import-dashboards) that come with the official Beats and use them as a starting point for your own dashboards. When you’re done making changes to the dashboards in Kibana, you can use the `export_dashboards` script to [export the dashboards](https://www.elastic.co/docs/extend/beats/export-dashboards), along with all dependencies, to a local directory.
To make sure the dashboards are compatible with the latest version of Kibana and Elasticsearch, we recommend that you use the virtual environment under [beats/testing/environments](https://github.com/elastic/beats/tree/master/testing/environments) to import, create, and export the Kibana dashboards.
The following topics provide more detail about importing and working with Beats dashboards:
- [Importing Existing Beat Dashboards](https://www.elastic.co/docs/extend/beats/import-dashboards)
- [Building Your Own Beat Dashboards](https://www.elastic.co/docs/extend/beats/build-dashboards)
- [Generating the Beat Index Pattern](https://www.elastic.co/docs/extend/beats/generate-index-pattern)
- [Exporting New and Modified Beat Dashboards](https://www.elastic.co/docs/extend/beats/export-dashboards)
- [Archiving Your Beat Dashboards](https://www.elastic.co/docs/extend/beats/archive-dashboards)
- [Sharing Your Beat Dashboards](https://www.elastic.co/docs/extend/beats/share-beat-dashboards)