﻿---
title: Extending Metricbeat
description: Metricbeat periodically interrogates other services to fetch key metrics information. As a developer, you can use Metricbeat in two different ways: Extend...
url: https://www.elastic.co/docs/extend/beats/metricbeat-developer-guide
products:
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Extending Metricbeat
Metricbeat periodically interrogates other services to fetch key metrics information. As a developer, you can use Metricbeat in two different ways:
- Extend Metricbeat directly
- Create your own Beat and use Metricbeat as a library

We recommend that you start by creating your own Beat to keep the development of your own module or metricset independent of Metricbeat. At a later stage, if you decide to add a module to Metricbeat, you can reuse the code without making additional changes.
This following topics describe how to contribute to Metricbeat by adding metricsets, modules, and new Beats based on Metricbeat:
- [Overview](https://www.elastic.co/docs/extend/beats/metricbeat-dev-overview)
- [Creating a Metricset](https://www.elastic.co/docs/extend/beats/creating-metricsets)
- [Metricset Details](https://www.elastic.co/docs/extend/beats/metricset-details)
- [Creating a Metricbeat Module](https://www.elastic.co/docs/extend/beats/creating-metricbeat-module)
- [Metricbeat Developer FAQ](https://www.elastic.co/docs/extend/beats/dev-faq)

If you would like to contribute to Metricbeat or the Beats project, also see [*Contributing to Beats*](https://www.elastic.co/docs/extend/beats).