﻿---
title: Defining field mappings
description: You must define the fields used by your Beat, along with their mapping details, in _meta/fields.yml. After editing this file, run make update. Define...
url: https://www.elastic.co/docs/extend/beats/event-fields-yml
products:
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Defining field mappings
You must define the fields used by your Beat, along with their mapping details, in `_meta/fields.yml`. After editing this file, run `make update`.
Define the field mappings in the `fields` array:
```yaml
- key: mybeat
  title: mybeat
  description: These are the fields used by mybeat.
  fields:
    - name: last_name 
      type: keyword 
      required: true 
      description: > 
        The last name.
    - name: first_name
      type: keyword
      required: true
      description: >
        The first name.
    - name: comment
      type: text
      required: false
      description: >
        Comment made by the user.
```


## Mapping parameters

You can specify other mapping parameters for each field. See the [Elasticsearch Reference](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-parameters) for more details about each parameter.
<definitions>
  <definition term="format">
    Specify a custom date format used by the field.
  </definition>
  <definition term="multi_fields">
    For `text` or `keyword` fields, use `multi_fields` to define multi-field mappings.
  </definition>
  <definition term="enabled">
    Whether or not the field is enabled.
  </definition>
  <definition term="analyzer">
    Which analyzer to use when indexing.
  </definition>
  <definition term="search_analyzer">
    Which analyzer to use when searching.
  </definition>
  <definition term="norms">
    Applies to `text` and `keyword` fields. Default is `false`.
  </definition>
  <definition term="dynamic">
    Dynamic field control. Can be one of `true` (default), `false`, or `strict`.
  </definition>
  <definition term="index">
    Whether or not the field should be indexed.
  </definition>
  <definition term="doc_values">
    Whether or not the field should have doc values generated.
  </definition>
  <definition term="copy_to">
    Which field to copy the field value into.
  </definition>
  <definition term="ignore_above">
    Elasticsearch ignores (does not index) strings that are longer than the specified value. When this property value is missing or `0`, the `libbeat` default value of `1024` characters is used. If the value is `-1`, the Elasticsearch default value is used.
  </definition>
</definitions>

For example, you can use the `copy_to` mapping parameter to copy the `last_name` and `first_name` fields into the `full_name` field at index time:
```yaml
- key: mybeat
  title: mybeat
  description: These are the fields used by mybeat.
  fields:
    - name: last_name
      type: text
      required: true
      copy_to: full_name 
      description: >
        The last name.
    - name: first_name
      type: text
      required: true
      copy_to: full_name 
      description: >
        The first name.
    - name: full_name
      type: text
      required: false
      description: >
        The last_name and first_name combined into one field for easy searchability.
```

There are also some Kibana-specific properties, not detailed here. These are: `analyzed`, `count`, `searchable`, `aggregatable`, and `script`. Kibana parameters can also be described using `pattern`, `input_format`, `output_format`, `output_precision`, `label_template`, `url_template`, and `open_link_in_current_tab`.

## Defining text multi-fields

There are various options that you can apply when using text fields. You can define a simple text field using the default analyzer without any other options, as in the example shown earlier.
To keep the original keyword value when using `text` mappings, for instance to use in aggregations or ordering, you can use a multi-field mapping:
```yaml
- key: mybeat
  title: mybeat
  description: These are the fields used by mybeat.
  fields:
    - name: city
      type: text
      multi_fields: 
        - name: keyword 
          type: keyword 
```

For more information, see the [Elasticsearch documentation about multi-fields](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/multi-fields).

## Defining a text analyzer in-line

It is possible to define a new text analyzer or search analyzer in-line with the field definition in the field’s mapping parameters.
For example, you can define a new text analyzer that does not break hyphenated names:
```yaml
- key: mybeat
  title: mybeat
  description: These are the fields used by mybeat.
  fields:
    - name: last_name
      type: text
      required: true
      description: >
        The last name.
      analyzer:
        mybeat_hyphenated_name: 
          type: pattern 
          pattern: "[\\W&&[^-]]+" 
      search_analyzer:
        mybeat_hyphenated_name: 
          type: pattern
          pattern: "[\\W&&[^-]]+"
```

The names of custom analyzers that are defined in-line may not be reused for a different text analyzer. If a text analyzer name is reused it is checked for matching existing instances of the analyzer. It is recommended that the analyzer name is prefixed with the beat name to avoid name clashes.
For more information, see [Elasticsearch documentation about defining custom text analyzers](https://www.elastic.co/docs/manage-data/data-store/text-analysis/create-custom-analyzer).