﻿---
title: Alert triggers
description: Understand alert triggers and how to create and configure them.
url: https://www.elastic.co/docs/explore-analyze/workflows/triggers/alert-triggers
applies_to:
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
---

# Alert triggers
Alert triggers run workflows automatically when detection or alerting rules generate an alert. Use alert triggers for alert enrichment, automated incident response, case creation, or notification routing.
When a rule generates an alert that triggers your workflow, the trigger provides rich context data to the workflow through the `event` field.
To set up an alert trigger, follow these steps:
<stepper>
  <step title="Define an alert trigger">
    Create a workflow with an alert trigger:
    ```yaml
    name: Security Alert Response
    description: Enriches and triages security alerts
    enabled: true
    triggers:
      - type: alert
    steps:
      ....
    ```
  </step>

  <step title="Configure the alert rule">
    After creating your workflow, configure your alert rule to trigger it.
    <tab-set>
      <tab-item title="Alerting rules">
        1. Go to **Rules** in **Stack Management** or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
        2. Find or create the alerting rule you want to trigger the workflow.
        3. In the rule settings, under **Actions**, select **Add action**.
        4. Select **Workflows**.
        5. Select your workflow from the dropdown or create a new one. You can only select enabled workflows.
        6. Under **Action frequency**, choose whether to run separate workflows for each generated alert.
        7. (Optional) Add multiple workflows by selecting **Add action** again.
        8. Create or save the rule.

        ![Alerting rule settings showing a workflow selected as an action](https://www.elastic.co/docs/explore-analyze/images/workflows-alerting-rule-action.png)
      </tab-item>

      <tab-item title="Security detection rules">
        1. Go to **Detection rules (SIEM)** in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
        2. Find or create the detection rule you want to trigger the workflow.
        3. In the rule settings, under **Actions**, select **Workflows**.
        4. Select your workflow from the dropdown or create a new one. You can only select enabled workflows.
        5. Under **Action frequency**, choose whether to run separate workflows for each generated alert.
        6. (Optional) Add multiple workflows by selecting **Add action**.
        7. Create or save the rule.

        ![Detection rule settings showing a workflow selected as an action](https://www.elastic.co/docs/explore-analyze/images/workflows-detection-rule-action.png)
      </tab-item>
    </tab-set>
  </step>
</stepper>

When the configured rule generates an alert, your workflow automatically executes with the alert context.