﻿---
title: Action steps
description: Learn about action steps that perform tasks in your workflows.
url: https://www.elastic.co/docs/explore-analyze/workflows/steps/action-steps
applies_to:
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
---

# Action steps
Action steps are the building blocks that perform tasks in your workflows. They are the operations that do the work, such as searching data, calling an API, sending a notification, or interacting with external systems.
Action steps are organized into the following categories.

## Elasticsearch

Elasticsearch actions provide native integration with Elasticsearch APIs. These actions are automatically authenticated and offer a simplified interface for common operations. Use Elasticsearch actions to:
- Search and query data
- Index new documents
- Update or delete existing documents
- Manage indices and data streams

Refer to [Elasticsearch action steps](https://www.elastic.co/docs/explore-analyze/workflows/steps/elasticsearch) for more information.

## Kibana

Kibana actions provide native integration with Kibana APIs. Like Elasticsearch actions, they are automatically authenticated and simplify common operations. Use Kibana actions to:
- Create or update cases
- Manage alerts
- Interact with saved objects and other Kibana features

Refer to [Kibana action steps](https://www.elastic.co/docs/explore-analyze/workflows/steps/kibana) for more information.

## External systems and apps

External actions allow your workflows to communicate with third-party systems using connectors. Use external actions to:
- Send notifications to Slack or email
- Create incidents in ServiceNow
- Create issues in Jira
- Call any external API using HTTP requests

Refer to [External systems and apps steps](https://www.elastic.co/docs/explore-analyze/workflows/steps/external-systems-apps) for more information.