﻿---
title: Set up workflows
description: Learn how to enable workflows and configure role-based access.
url: https://www.elastic.co/docs/explore-analyze/workflows/setup
applies_to:
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
---

# Set up workflows
To use workflows, you must turn on the feature and ensure your role has the appropriate privileges. You must also have the appropriate subscription. Refer to the subscription page for [Elastic Cloud](https://www.elastic.co/subscriptions/cloud) and [Elastic Stack/self-managed](https://www.elastic.co/subscriptions) for the breakdown of available features and their associated subscription tiers.

## Enable workflows

The workflows feature is turned off by default. To turn it on:
1. Go to the **Advanced Settings** management page in the navigation menu or using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Search for `workflows:ui:enabled`.
3. Toggle the setting on.
4. Click **Save changes** to turn on workflows in your space, then reload the page.

The **Workflows** page displays in the main navigation menu and you can search for it using the global search field.

## Manage access to workflows

Access to workflows is controlled by [Kibana privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges). The following table describes privileges required to create, edit, run, and manage workflows.

| Action                                    | Required privilege                                       |
|-------------------------------------------|----------------------------------------------------------|
| Access the **Workflows** page             | `All` or `Read` for **Analytics > Workflows**            |
| Fully manage workflows                    | `All` for **Analytics > Workflows**                      |
| Grant access to specific workflow actions | Set sub-feature privileges for **Analytics > Workflows** |


## What's next

- Create and run your first workflow. Refer to [Get started with workflows](https://www.elastic.co/docs/explore-analyze/workflows/get-started) to learn more
- Understand how to use the YAML editor in Kibana to define and run workflows. Refer to [Author workflows](https://www.elastic.co/docs/explore-analyze/workflows/author-workflows) to learn more.