﻿---
title: Manage workflows
description: Learn how to view, organize, and manage your workflows.
url: https://www.elastic.co/docs/explore-analyze/workflows/manage-workflows
applies_to:
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
---

# Manage workflows
The **Workflows** page allows you to view and manage all your workflows. From the page, you can create, edit, duplicate, delete, and more with your workflows. To find the **Workflows** page, use the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
<admonition title="Requirements">
  To use workflows, you must turn on the feature and ensure your role has the appropriate privileges. Refer to [Set up workflows](https://www.elastic.co/docs/explore-analyze/workflows/setup) for more information.You must also have the appropriate subscription. Refer to the subscription page for [Elastic Cloud](https://www.elastic.co/subscriptions/cloud) and [Elastic Stack/self-managed](https://www.elastic.co/subscriptions) for the breakdown of available features and their associated subscription tiers.
</admonition>

![A view of Workflows editor](https://www.elastic.co/docs/explore-analyze/images/workflows-page.png)


## Available actions

From the Workflows page, you can create new workflows, search and filter existing ones, manually trigger workflows, and more.

### Create a workflow

Click **Create a new workflow** to open the YAML editor. Refer to [Author workflows](https://www.elastic.co/docs/explore-analyze/workflows/author-workflows) to learn how to use the editor.

### Search and filter

Use the search bar to filter workflows by name, description, or tag. You can also use the **Enabled** filter to only show workflows that are turned on (enabled) or off (disabled), and the **Created By** filter to only show workflows created by the specified user.

### Run a workflow

To instantly run a workflow, click the **Run** icon `play` for a workflow, or open the **All actions** menu (`boxes_vertical`) and click **Run**. The workflow manually runs regardless of its specified triggers. To learn about monitoring workflow runs, refer to [Monitor and troubleshoot workflows](https://www.elastic.co/docs/explore-analyze/workflows/monitor-troubleshoot).

### Edit a workflow

Click the **Edit** icon to open the workflow in the YAML editor. Alternatively, open the **All actions** menu (`boxes_vertical`), and click **Edit**.

### Turn a workflow on or off

Use the **Enabled** toggle to control whether a workflow can run:
- **Enabled**: The workflow responds to its configured triggers.
- **Disabled**: The workflow won't run, even if it's triggered.