﻿---
title: Author workflows
description: Reference guide for the workflow YAML editor interface.
url: https://www.elastic.co/docs/explore-analyze/workflows/author-workflows
applies_to:
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
---

# Author workflows
The YAML editor is the primary interface for creating and editing workflows. This page describes the editor's components and features.
<admonition title="Requirements">
  To use workflows, you must turn on the feature and ensure your role has the appropriate privileges. Refer to [Set up workflows](https://www.elastic.co/docs/explore-analyze/workflows/setup) for more information.You must also have the appropriate subscription. Refer to the subscription page for [Elastic Cloud](https://www.elastic.co/subscriptions/cloud) and [Elastic Stack/self-managed](https://www.elastic.co/subscriptions) for the breakdown of available features and their associated subscription tiers.
</admonition>

![A view of Workflows editor](https://www.elastic.co/docs/explore-analyze/images/workflows-editor.png)


## Editor layout

The editor layout is composed of the following elements:

| Component           | Description                                                                                                                                                                                                                                                                                                                                                 |
|---------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Editor pane**     | The main area for writing and editing workflows. To learn more about the expected workflow structure, refer to [Workflows](https://www.elastic.co/docs/explore-analyze/workflows)                                                                                                                                                                           |
| **Actions menu**    | A quick-add menu for pre-formatted [triggers](https://www.elastic.co/docs/explore-analyze/workflows/triggers) and [step types](https://www.elastic.co/docs/explore-analyze/workflows/steps).                                                                                                                                                                |
| **Save button**     | Saves the current workflow.                                                                                                                                                                                                                                                                                                                                 |
| **Run button**      | Manually runs the entire workflow or an individual step.  - Entire workflow: Click the **Run** icon `play` (next to **Save**).   - Individual step: Select the step in the editor pane, then click the **Run** icon `play`.                                                                                                                                 |
| **Executions tab**  | Shows [execution history](https://www.elastic.co/docs/explore-analyze/workflows/monitor-troubleshoot) and real-time logs.                                                                                                                                                                                                                                   |
| **Validation logs** | Shows validation successes and failures. Some common validation errors include:  - Invalid YAML syntax because of incorrect indentation or formatting  - Missing a required field or property (for example, `name`, `type`)  - The step type is unknown or doesn't match a valid action  - Invalid template syntax because of malformed template expression |