﻿---
title: Text panels
description: To provide context to your dashboard panels, add Text panels that display important information, instructions, images, and more. You can create Text panels...
url: https://www.elastic.co/docs/explore-analyze/visualize/text-panels
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Text panels
To provide context to your dashboard panels, add **Text** panels that display important information, instructions, images, and more. You can create **Text** panels using GitHub-flavored Markdown text.
<applies-switch>
  <applies-item title="{ stack: ga 9.2, serverless: }" applies-to="Elastic Cloud Serverless: Generally available, Elastic Stack: Generally available since 9.2">
    1. From your dashboard, select **Add** => **New panel**.
    2. In the **Add panel** flyout, select **Markdown Text**. A Markdown editor appears and lets you configure the information you want to display.
    3. Enter your text, then click **Apply**.
    While switching between **Editor** and **Preview** modes, you can keep editing your text.For example, in **Editor** mode you enter:
    ![Markdown text with links](https://www.elastic.co/docs/explore-analyze/images/kibana-markdown-editor-mode.png)
    The following instructions are displayed in **Preview** mode:
    ![Panel with markdown link text](https://www.elastic.co/docs/explore-analyze/images/kibana-markdown-preview-mode.png)
    Or when you enter:
    ![Markdown text with image file](https://www.elastic.co/docs/explore-analyze/images/kibana-markdown-editor-screenshot.png)
    The following image is displayed:
    ![Panel with markdown image](https://www.elastic.co/docs/explore-analyze/images/kibana-markdown-preview-screenshot.png)
    For detailed information about writing on GitHub, click **Syntax help** on the top-right of the Markdown editor.
  </applies-item>

  <applies-item title="stack: ga 9.0-9.1" applies-to="Elastic Stack: Generally available from 9.0 to 9.1">
    1. From your dashboard, select **Add panel**.
    2. In the **Add panel** flyout, select **Text**. A Markdown editor appears and lets you configure the information you want to display.
    3. In the **Markdown** field, enter your text, then click **Update**.
    For example, when you enter:
    ![Markdown text with links](https://www.elastic.co/docs/explore-analyze/images/kibana-markdown_example_1.png)
    The following instructions are displayed:
    ![Panel with markdown link text](https://www.elastic.co/docs/explore-analyze/images/kibana-markdown_example_2.png)
    Or when you enter:
    ![Markdown text with image file](https://www.elastic.co/docs/explore-analyze/images/kibana-markdown_example_3.png)
    The following image is displayed:
    ![Panel with markdown image](https://www.elastic.co/docs/explore-analyze/images/kibana-markdown_example_4.png)
    For detailed information about writing on GitHub, click **Help** on the top-right of the Markdown editor.
  </applies-item>
</applies-switch>