﻿---
title: Supported chart types
description: For step-by-step guidance on building area charts in Lens, see Area charts. Metric aggregations are calculated from the values in the aggregated documents...
url: https://www.elastic.co/docs/explore-analyze/visualize/supported-chart-types
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Supported chart types
| Panel type                      | **Lens** | **TSVB** | **Aggregation-based** | **Vega** | **Timelion** |
|---------------------------------|----------|----------|-----------------------|----------|--------------|
| Table                           |          |          |                       |          |              |
| Bar, line, and area             |          |          |                       |          |              |
| Split chart and small multiples |          |          |                       |          |              |
| Pie and donut                   |          |          |                       |          |              |
| Sunburst                        |          |          |                       |          |              |
| Treemap                         |          |          |                       |          |              |
| Heatmap                         |          |          |                       |          |              |
| Gauge and Goal                  |          |          |                       |          |              |
| Markdown                        |          |          |                       |          |              |
| Metric                          |          |          |                       |          |              |
| Tag cloud                       |          |          |                       |          |              |


## Bar, line, and area chart features

For step-by-step guidance on building area charts in Lens, see [Area charts](https://www.elastic.co/docs/explore-analyze/visualize/charts/area-charts).

| Feature                       | **Lens**     | **TSVB**         | **Aggregation-based** | **Vega** | **Timelion** |
|-------------------------------|--------------|------------------|-----------------------|----------|--------------|
| Dense time series             | Customizable |                  | Customizable          |          |              |
| Percentage mode               |              |                  |                       |          |              |
| Break downs                   | 1            | 1                | 3                     | ∞        | 1            |
| Custom color with break downs |              | Only for Filters |                       |          |              |
| Fit missing values            |              |                  |                       |          |              |
| Synchronized tooltips         |              |                  |                       |          |              |


## Advanced features


| Feature                             | **Lens** | **TSVB** | **Vega** | **Timelion** |
|-------------------------------------|----------|----------|----------|--------------|
| Math                                |          |          |          |              |
| Math across indices                 |          |          |          |              |
| Visualize two indices               |          |          |          |              |
| Time shift                          |          |          |          |              |
| Custom Elasticsearch queries        |          |          |          |              |
| Normalize by time                   |          |          |          |              |
| Automatically generated suggestions |          |          |          |              |
| Annotations                         |          |          |          |              |


## Table features


| Feature           | **Lens** | **TSVB** | **Aggregation-based** |
|-------------------|----------|----------|-----------------------|
| Summary row       |          |          |                       |
| Pivot table       |          |          |                       |
| Calculated column | Formula  |          | Percent only          |
| Color by value    |          |          |                       |


## Functions


| Function                                                                                     | **Lens**                                                          | **TSVB** |
|----------------------------------------------------------------------------------------------|-------------------------------------------------------------------|----------|
| Counter rate                                                                                 |                                                                   |          |
| [Filter ratio](/docs/explore-analyze/visualize/legacy-editors/tsvb#tsvb-function-reference)  | Use [formula](/docs/explore-analyze/visualize/lens#lens-formulas) |          |
| [Positive only](/docs/explore-analyze/visualize/legacy-editors/tsvb#tsvb-function-reference) |                                                                   |          |
| [Series agg](/docs/explore-analyze/visualize/legacy-editors/tsvb#tsvb-function-reference)    | Use [formula](/docs/explore-analyze/visualize/lens#lens-formulas) |          |
| Static value                                                                                 |                                                                   |          |


## Metrics aggregations

Metric aggregations are calculated from the values in the aggregated documents. The values are extracted from the document fields.

| Aggregation                | **Lens** | **TSVB** | **Aggregation-based** | **Vega** |
|----------------------------|----------|----------|-----------------------|----------|
| Metrics with filters       |          |          |                       |          |
| Average, Sum, Max, Min     |          |          |                       |          |
| Unique count (Cardinality) |          |          |                       |          |
| Percentiles and Median     |          |          |                       |          |
| Percentiles Rank           |          |          |                       |          |
| Standard deviation         |          |          |                       |          |
| Sum of squares             |          |          |                       |          |
| Top hit (Last value)       |          |          |                       |          |
| Value count                |          |          |                       |          |
| Variance                   |          |          |                       |          |

For information about Elasticsearch metrics aggregations, refer to [Metrics aggregations](https://www.elastic.co/docs/reference/aggregations/metrics).

## Bucket aggregations

Bucket aggregations group, or bucket, documents based on the aggregation type. To define the document buckets, bucket aggregations compute and return the number of documents for each bucket.

| Aggregation       | **Lens**    | **TSVB**    | **Aggregation-based** | **Vega** |
|-------------------|-------------|-------------|-----------------------|----------|
| Histogram         |             |             |                       |          |
| Date histogram    |             |             |                       |          |
| Date range        | Use filters |             |                       |          |
| Filter            |             |             |                       |          |
| Filters           |             |             |                       |          |
| GeoHash grid      |             |             |                       |          |
| IP prefix         | Use filters | Use filters |                       |          |
| IP range          | Use filters | Use filters |                       |          |
| Range             |             | Use filters |                       |          |
| Terms             |             |             |                       |          |
| Significant terms |             |             |                       |          |

For information about Elasticsearch bucket aggregations, refer to [Bucket aggregations](https://www.elastic.co/docs/reference/aggregations/bucket).

## Pipeline aggregations

Pipeline aggregations are dependent on the outputs calculated from other aggregations. Parent pipeline aggregations are provided with the output of the parent aggregation, and compute new buckets or aggregations that are added to existing buckets. Sibling pipeline aggregations are provided with the output of a sibling aggregation, and compute new aggregations for the same level as the sibling aggregation.

| Aggregation         | **Lens**                                                                        | **TSVB** | **Aggregation-based** | **Vega** |
|---------------------|---------------------------------------------------------------------------------|----------|-----------------------|----------|
| Avg bucket          | [`overall_average` formula](/docs/explore-analyze/visualize/lens#lens-formulas) |          |                       |          |
| Derivative          |                                                                                 |          |                       |          |
| Max bucket          | [`overall_max` formula](/docs/explore-analyze/visualize/lens#lens-formulas)     |          |                       |          |
| Min bucket          | [`overall_min` formula](/docs/explore-analyze/visualize/lens#lens-formulas)     |          |                       |          |
| Sum bucket          | [`overall_sum` formula](/docs/explore-analyze/visualize/lens#lens-formulas)     |          |                       |          |
| Moving average      |                                                                                 |          |                       |          |
| Cumulative sum      |                                                                                 |          |                       |          |
| Bucket script       |                                                                                 |          |                       |          |
| Bucket selector     |                                                                                 |          |                       |          |
| Serial differencing |                                                                                 |          |                       |          |

For information about Elasticsearch pipeline aggregations, refer to [Pipeline aggregations](https://www.elastic.co/docs/reference/aggregations/pipeline).