﻿---
title: Vector tooltips
description: Vector tooltips display attributes for the features at your mouse location. These tooltips give users an in-depth insight into what’s going on in the...
url: https://www.elastic.co/docs/explore-analyze/visualize/maps/vector-tooltip
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Vector tooltips
Vector tooltips display attributes for the features at your mouse location. These tooltips give users an in-depth insight into what’s going on in the map.
If more than one feature exists at a location, the tooltip displays the attributes for the top feature, and notes the number of features at that location. The following image has a tooltip with three features at the current location: a green circle from the **Total Sales Revenue** layer, a blue New York State polygon from **United States** layer, and a red United States Country polygon from the **World Countries** layer. The tooltip displays attributes for the top feature, the green circle, from the **Total Sales Revenue** layer.
![multifeature tooltip](https://www.elastic.co/docs/explore-analyze/images/kibana-multifeature_tooltip.png)


## Format tooltips

You can format the attributes in a tooltip by adding [field formatters](/docs/explore-analyze/find-and-organize/data-views#managing-fields) to your data view. You can use field formatters to round numbers, provide units, and even display images in your tooltip.

## Lock a tooltip at the current location

You can lock a tooltip in place by clicking a location on the map. With locked tooltips you can:
- Page through features.
- Create a [phrase filter](/docs/explore-analyze/visualize/maps/maps-create-filter-from-map#maps-phrase-filter) from a feature attribute value.
- Create a [spatial filter](/docs/explore-analyze/visualize/maps/maps-create-filter-from-map#maps-spatial-filters) from a feature’s geometry.

This image shows a locked tooltip with features from three layers. The tooltip displays attributes for the second feature, the blue New York State polygon.  The tooltip includes controls for paging through the features and a dropdown menu for filtering the features by layer.
![locked tooltip](https://www.elastic.co/docs/explore-analyze/images/kibana-locked_tooltip.png)