﻿---
title: Vector layer
description: Vector layers display points, lines, and polygons. To add a vector layer to your map, click Add layer, then select one of the following: 
url: https://www.elastic.co/docs/explore-analyze/visualize/maps/vector-layer
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Vector layer
Vector layers display points, lines, and polygons.
![vector layer](https://www.elastic.co/docs/explore-analyze/images/kibana-vector_layer.png)

To add a vector layer to your map, click **Add layer**, then select one of the following:
<definitions>
  <definition term="Choropleth">
    Shaded areas to compare statistics across boundaries.
  </definition>
  <definition term="Clusters">
    Geospatial data grouped in grids with metrics for each gridded cell. The index must contain at least one field mapped as [geo_point](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-point) or [geo_shape](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-shape).
  </definition>
  <definition term="Create index">
    Draw shapes on the map and index in Elasticsearch.
  </definition>
  <definition term="Documents">
    Points, lines, and polyons from Elasticsearch. The index must contain at least one field mapped as [geo_point](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-point) or [geo_shape](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-shape).
    Results are limited to the `index.max_result_window` index setting, which defaults to 10000. Select the appropriate **Scaling** option for your use case.
    - **Limit results to 10,000** The layer displays features from the first `index.max_result_window` documents. Results exceeding `index.max_result_window` are not displayed.
    - **Show clusters when results exceed 10,000** When results exceed `index.max_result_window`, the layer uses [GeoTile grid aggregation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-bucket-geotilegrid-aggregation) to group your documents into clusters and displays metrics for each cluster. When results are less then `index.max_result_window`, the layer displays features from individual documents.
    - **Use vector tiles.** Vector tiles partition your map into tiles. Each tile request is limited to the `index.max_result_window` index setting. When a tile exceeds `index.max_result_window`, results exceeding `index.max_result_window` are not contained in the tile and a dashed rectangle outlining the bounding box containing all geo values within the tile is displayed.
  </definition>
  <definition term="EMS Boundaries">
    Administrative boundaries from [Elastic Maps Service](https://www.elastic.co/elastic-maps-service).
  </definition>
  <definition term="ML Anomalies">
    Points and lines associated with anomalies. The anomaly detection job must use a `lat_long` function. Go to [Detecting anomalous locations in geographic data](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/geographic-anomalies) for an example.
  </definition>
  <definition term="Point to point">
    Aggregated data paths between the source and destination. The index must contain at least 2 fields mapped as [geo_point](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-point), source and destination.
  </definition>
  <definition term="Top hits per entity">
    The layer displays the [most relevant documents per entity](https://www.elastic.co/docs/explore-analyze/visualize/maps/maps-top-hits-aggregation). The index must contain at least one field mapped as [geo_point](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-point) or [geo_shape](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-shape).
  </definition>
  <definition term="Tracks">
    Create lines from points. The index must contain at least one field mapped as [geo_point](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-point).
  </definition>
  <definition term="Upload Geojson">
    Index GeoJSON data in Elasticsearch.
  </definition>
</definitions>