﻿---
title: Point to point
description: A point-to-point connection plots aggregated data paths between the source and the destination. Thicker, darker lines symbolize more connections between...
url: https://www.elastic.co/docs/explore-analyze/visualize/maps/point-to-point
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Point to point
A point-to-point connection plots aggregated data paths between the source and the destination. Thicker, darker lines symbolize more connections between a source and destination, and thinner, lighter lines symbolize less connections.
Point to point uses an Elasticsearch [terms aggregation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-bucket-terms-aggregation) to group your documents by destination. Then, a nested [GeoTile grid aggregation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-bucket-geotilegrid-aggregation) groups sources for each destination into grids. A line connects each source grid centroid to each destination.
Point-to-point layers are used in several common use cases:
- Source-destination maps for network traffic
- Origin-destination maps for flight data
- Origin-destination flows for import/export/migration
- Origin-destination for pick-up/drop-off data

![point to point](https://www.elastic.co/docs/explore-analyze/images/kibana-point_to_point.png)