﻿---
title: Display the most relevant documents per entity
description: Use Top hits per entity to display the most relevant documents per entity, for example, the most recent GPS tracks per flight route. To get this data,...
url: https://www.elastic.co/docs/explore-analyze/visualize/maps/maps-top-hits-aggregation
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Display the most relevant documents per entity
Use **Top hits per entity** to display the most relevant documents per entity, for example, the most recent GPS tracks per flight route. To get this data, Elasticsearch first groups your data using a [terms aggregation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-bucket-terms-aggregation), then accumulates the most relevant documents based on sort order for each entry using a [top hits metric aggregation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-top-hits-aggregation).
To enable top hits:
1. Click **Add layer**, then select the **Top hits per entity** layer.
2. Configure **Data view** and **Geospatial field**.
3. Set **Entity** to the field that identifies entities in your documents. This field will be used in the terms aggregation to group your documents into entity buckets.
4. Set **Documents per entity** to configure the maximum number of documents accumulated per entity. This setting is limited to the `index.max_inner_result_window` index setting, which defaults to 100.

![top hits](https://www.elastic.co/docs/explore-analyze/images/kibana-top_hits.png)