﻿---
title: Configure map settings
description: Maps offers settings that let you configure how a map is displayed. To access these settings, click Settings in the application toolbar. Add, edit, or...
url: https://www.elastic.co/docs/explore-analyze/visualize/maps/maps-settings
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Configure map settings
Maps offers settings that let you configure how a map is displayed. To access these settings, click **Settings** in the application toolbar.

## Custom icons

Add, edit, or delete custom icons for the map. Icons added to the map can be used for [styling Point features](/docs/explore-analyze/visualize/maps/maps-vector-style-properties#point-style-properties).

## Display

<definitions>
  <definition term="Background color">
    Set the map background color.
  </definition>
  <definition term="Show scale">
    When enabled, display the map scale.
  </definition>
</definitions>


## Navigation

<definitions>
  <definition term="Auto fit map to bounds">
    When enabled, the map will automatically pan and zoom to show the filtered data bounds.
  </definition>
  <definition term="Zoom range">
    Constrain the map to the defined zoom range.
  </definition>
  <definition term="Initial map location">
    Configure the initial map center and zoom.
    - **Map location at save**: Use the map center and zoom from the map position at the time of the latest save.
    - **Auto fit map to bounds**: Set the initial map location to show the filtered data bounds.
    - **Fixed location**: Lock the map center and zoom to fixed values.
    - **Browser location**: Set the initial map center to the browser location.
  </definition>
</definitions>


## Spatial filters

Use spatial filter settings to configure how [spatial filters](/docs/explore-analyze/visualize/maps/maps-create-filter-from-map#maps-spatial-filters) are displayed.
![spatial filters](https://www.elastic.co/docs/explore-analyze/images/kibana-spatial_filters.png)

<definitions>
  <definition term="Show spatial filters on map">
    Clear the checkbox so [spatial filters](/docs/explore-analyze/visualize/maps/maps-create-filter-from-map#maps-spatial-filters) do not appear on the map.
  </definition>
  <definition term="Opacity">
    Set the opacity of spatial filters.
  </definition>
  <definition term="Fill color">
    Set the fill color of spatial filters.
  </definition>
  <definition term="Border color">
    Set the border color of spatial filters.
  </definition>
</definitions>