﻿---
title: Search geographic data
description: Search across the layers in your map to focus on just the data you want. Combine free text search with field-based search using the Kibana Query Language...
url: https://www.elastic.co/docs/explore-analyze/visualize/maps/maps-search
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Search geographic data
Search across the layers in your map to focus on just the data you want. Combine free text search with field-based search using the [Kibana Query Language](https://www.elastic.co/docs/explore-analyze/query-filter/languages/kql). Set the time filter to restrict layers by time.
This image shows an example of global search and global time narrowing results.
![global search and global time narrowing results](https://www.elastic.co/docs/explore-analyze/images/kibana-global_search_bar.png)

Only layers requesting data from Elasticsearch are narrowed by global search and global time. To add a layer that requests data from Elasticsearch to your map, click **Add layer**, then select one of the following:
- Documents
- Choropleth
- Clusters and grid
- Heat map
- Point to point
- Top hits per entity
- Tracks


## Narrow layers by global search

Layers that request data from Elasticsearch are narrowed when you submit a search. Layers narrowed by semi-structured search and filters contain the filter icon ![filter icon](https://www.elastic.co/docs/explore-analyze/images/kibana-filter_icon.png) next to the layer name in the legend.
To prevent the global search from applying to a layer, configure the following:
- In **Filtering**, clear the **Apply global search to layer data** checkbox to turn off global search for the layer source.
- In **Term joins**, clear the **Apply global search to join** checkbox to turn off global search for the [term join](https://www.elastic.co/docs/explore-analyze/visualize/maps/terms-join).


## Narrow layers by global time

Layers that request data from Elasticsearch using a [data view](https://www.elastic.co/docs/explore-analyze/find-and-organize/data-views) with a configured time field are narrowed by the [global time](https://www.elastic.co/docs/explore-analyze/query-filter/filtering). These layers contain the clock icon ![clock icon](https://www.elastic.co/docs/explore-analyze/images/kibana-clock_icon.png) next to the layer name in the legend.
Use the time slider to quickly select time slices within the global time range:
1. Click ![timeslider icon](https://www.elastic.co/docs/explore-analyze/images/kibana-timeslider_toggle_icon.png) to open the time slider.
2. Click previous and next buttons to advance the time slice backward or forward.
3. Click play to animate your spatial temporal data.

To prevent the global time filter from applying to a layer, configure the following:
- In **Filtering**, clear the **Apply global time to layer data** checkbox to turn off the global time for the layer source.
- In **Term joins**, clear the **Apply global time to join** checkbox to turn off the global time for the [term join](https://www.elastic.co/docs/explore-analyze/visualize/maps/terms-join).


## Refresh layer data

Layers that request data from Elasticsearch re-fetch data when [automatic refresh](https://www.elastic.co/docs/explore-analyze/query-filter/filtering) fires and when you click **Refresh**.
To prevent refreshing layer data, configure the following:
- In **Filtering**, clear the **Apply global refresh to layer data** checkbox to turn off refresh for the layer source.