﻿---
title: Search across multiple indices
description: Your map might contain multiple Elasticsearch indices. This can occur when your map contains two or more layers with Elasticsearch sources from different...
url: https://www.elastic.co/docs/explore-analyze/visualize/maps/maps-search-across-multiple-indices
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Search across multiple indices
Your map might contain multiple Elasticsearch indices. This can occur when your map contains two or more layers with Elasticsearch sources from different indices. This can also occur with a single layer with an Elasticsearch source and a [Term join](https://www.elastic.co/docs/explore-analyze/visualize/maps/terms-join).
Searching across multiple indices might sometimes result in empty layers. The most common cause for empty layers are searches for a field that exists in one index, but does not exist in other indices.

## Disable global search for a layer

One strategy for eliminating unintentional empty layers from a cross index search is to [disable global search for a layer](/docs/explore-analyze/visualize/maps/maps-search#maps-narrow-layer-by-global-search).

## Use _index in a search

Add [_index](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-index-field) to your search to include documents from indices that do not contain a search field.
For example, suppose you have a vector layer showing the `kibana_sample_data_logs` documents and another vector layer with `kibana_sample_data_flights` documents. (See [adding sample data](https://www.elastic.co/docs/explore-analyze) to install the `kibana_sample_data_logs` and `kibana_sample_data_flights` indices.)
If you query for
```
machine.os.keyword : "osx"
```

the `kibana_sample_data_flights` layer is empty because the index `kibana_sample_data_flights` does not contain the field `machine.os.keyword` and no documents match the query.
![global search multiple indices query1](https://www.elastic.co/docs/explore-analyze/images/kibana-global_search_multiple_indices_query1.png)

If you instead query for
```
machine.os.keyword : "osx" or _index : "kibana_sample_data_flights"
```

the `kibana_sample_data_flights` layer includes data.
![global search multiple indices query2](https://www.elastic.co/docs/explore-analyze/images/kibana-global_search_multiple_indices_query2.png)