﻿---
title: Clusters
description: Clusters use Geotile grid aggregation or Geohex grid aggregation to group your documents into grids. You can calculate metrics for each gridded cell. 
url: https://www.elastic.co/docs/explore-analyze/visualize/maps/maps-grid-aggregation
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Clusters
Clusters use [Geotile grid aggregation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-bucket-geotilegrid-aggregation) or [Geohex grid aggregation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-bucket-geohexgrid-aggregation) to group your documents into grids. You can calculate metrics for each gridded cell.
Symbolize cluster metrics as:
<definitions>
  <definition term="Clusters">
    Uses [Geotile grid aggregation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-bucket-geotilegrid-aggregation) to group your documents into grids. Creates a [vector layer](https://www.elastic.co/docs/explore-analyze/visualize/maps/vector-layer) with a cluster symbol for each gridded cell. The cluster location is the weighted centroid for all documents in the gridded cell.
  </definition>
  <definition term="Grids">
    Uses [Geotile grid aggregation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-bucket-geotilegrid-aggregation) to group your documents into grids. Creates a [vector layer](https://www.elastic.co/docs/explore-analyze/visualize/maps/vector-layer) with a bounding box polygon for each gridded cell.
  </definition>
  <definition term="Heat map">
    Uses [Geotile grid aggregation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-bucket-geotilegrid-aggregation) to group your documents into grids. Creates a [heat map layer](https://www.elastic.co/docs/explore-analyze/visualize/maps/heatmap-layer) that clusters the weighted centroids for each gridded cell.
  </definition>
  <definition term="Hexbins">
    Uses [Geohex grid aggregation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-bucket-geohexgrid-aggregation) to group your documents into H3 hexagon grids. Creates a [vector layer](https://www.elastic.co/docs/explore-analyze/visualize/maps/vector-layer) with a hexagon polygon for each gridded cell.
  </definition>
</definitions>

To enable a clusters layer:
1. Click **Add layer**, then select the **Clusters** or **Heat map** layer.

To enable a blended layer that dynamically shows clusters or documents:
1. Click **Add layer**, then select the **Documents** layer.
2. Configure **Data view** and the **Geospatial field**.
3. In **Scaling**, select **Show clusters when results exceed 10000**.