﻿---
title: Build a map to compare metrics by country or region
description: If you are new to Maps, this tutorial is a good place to start. It guides you through the common steps for working with your location data. You will learn...
url: https://www.elastic.co/docs/explore-analyze/visualize/maps/maps-getting-started
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Build a map to compare metrics by country or region
If you are new to **Maps**, this tutorial is a good place to start. It guides you through the common steps for working with your location data.
You will learn to:
- Create a map with multiple layers and data sources
- Use symbols, colors, and labels to style data values
- Embed a map in a dashboard
- Search across panels in your dashboard

When you complete this tutorial, you’ll have a map that looks like this:
![sample data web logs](https://www.elastic.co/docs/explore-analyze/images/kibana-sample_data_web_logs.png)


## Prerequisites

- If you don’t already have Kibana, set it up with [our free trial](https://www.elastic.co/cloud/elasticsearch-service/signup?baymax=docs-body&elektra=docs).
- This tutorial requires the [web logs sample data set](/docs/explore-analyze#gs-get-data-into-kibana). The sample data includes a [Logs] Total Requests and Bytes map, which you’ll re-create in this tutorial.
- You must have the correct privileges for creating a map. If you don’t have sufficient privileges to create or save maps, a read-only icon appears in the toolbar. For more information, refer to [Granting access to Kibana](https://www.elastic.co/docs/reference/elasticsearch/roles).


## Step 1. Create a map

1. Go to **Dashboards**.
2. Click **Create dashboard**.
3. Set the time range to **Last 7 days**.
4. Click the **Create new Maps** icon ![app gis icon](https://www.elastic.co/docs/explore-analyze/images/kibana-app_gis_icon.png).


## Step 2. Add a choropleth layer

The first layer you’ll add is a choropleth layer to shade world countries by web log traffic. Darker shades will symbolize countries with more web log traffic, and lighter shades will symbolize countries with less traffic.
1. Click **Add layer**, and then click **Choropleth**.
2. From the **EMS boundaries** dropdown menu, select **World Countries**.
3. In **Statistics source**, set:
   - **Data view** to **kibana_sample_data_logs**
- **Join field** to **geo.dest**
4. Click **Add and continue**.
5. In **Layer settings**, set:
   - **Name** to `Total Requests by Destination`
- **Opacity** to 50%
6. Add a Tooltip field:
   - **ISO 3166-1 alpha-2 code** is added by default.
- Click **+ Add** to open the field select.
- Select **name** and click **Add**.
7. In **Layer style**:
   - Set **Fill color > As number** to the grey color ramp.
- Set **Border color** to white.
- Under **Label**, change **By value** to **Fixed**.
8. Click **Keep changes**.
   Your map now looks like this:
   ![Map showing the Total Requests by Destination layer](https://www.elastic.co/docs/explore-analyze/images/kibana-gs_add_cloropeth_layer.png)


## Step 3. Add layers for the Elasticsearch data

To avoid overwhelming the user with too much data at once, you’ll add two layers for the Elasticsearch data. The first layer will display individual documents when users zoom in on the map. The second layer will display aggregated data when users zoom the map out.

### Add a layer for individual documents

This layer displays web log documents as points. The layer is only visible when users zoom in.
1. Click **Add layer**, and then click **Documents**.
2. Set **Data view** to **kibana_sample_data_logs**.
3. Click **Add and continue**.
4. In **Layer settings**, set:
   - **Name** to `Actual Requests`
- **Visibility** to the range [9, 24]
- **Opacity** to 100%
5. Add a tooltip field and select **agent**, **bytes**, **clientip**, **host**, **machine.os**, **request**, **response**, and **timestamp**.
6. In **Scaling**, enable **Limit results to 10,000.**
7. In **Layer style**, set **Fill color** to **#2200FF**.
8. Click **Keep changes**.
   Your map will look like this from zoom level 9 to 24:
   ![Map showing what zoom level looks like a level 9](https://www.elastic.co/docs/explore-analyze/images/kibana-gs_add_es_document_layer.png)


### Add a layer for aggregated data

You’ll create a layer for [aggregated data](https://www.elastic.co/docs/explore-analyze/query-filter/aggregations) and make it visible only when the map is zoomed out. Darker colors will symbolize grids with more web log traffic, and lighter colors will symbolize grids with less traffic. Larger circles will symbolize grids with more total bytes transferred, and smaller circles will symbolize grids with less bytes transferred.
1. Click **Add layer**, and select **Clusters**.
2. Set **Data view** to **kibana_sample_data_logs**.
3. Click **Add and continue**.
4. In **Layer settings**, set:
   - **Name** to `Total Requests and Bytes`
- **Visibility** to the range [0, 9]
- **Opacity** to 100%
5. In **Metrics**:
   - Set **Aggregation** to **Count**.
- Click **Add metric**.
- Set **Aggregation** to **Sum** with **Field** set to **bytes**.
6. In **Layer style**, change **Symbol size**:
   - Set **By value** to **sum bytes**.
- Set the min size to 7 and the max size to 25 px.
7. Click **Keep changes** button.
   Your map will look like this between zoom levels 0 and 9:
   ![Map showing what zoom level 3 looks like](https://www.elastic.co/docs/explore-analyze/images/kibana-sample_data_web_logs.png)


## Step 4. Save the map

Now that your map is complete, save it and return to the dashboard.
1. In the toolbar, click **Save and return**.


## Step 5. Explore your data from the dashboard

View your geospatial data alongside a heat map and pie chart, and then filter the data. When you apply a filter in one panel, it is applied to all panels on the dashboard.
1. Click **Add from library** to open a list of panels that you can add to the dashboard.
2. Add **[Logs] Unique Destination Heatmap** and **[Logs] Bytes distribution** to the dashboard.
   ![Map in a dashboard with 2 other panels](https://www.elastic.co/docs/explore-analyze/images/kibana-gs_dashboard_with_map.png)
3. To filter for documents with unusually high byte values, click and drag in the **Bytes distribution** chart.
4. Remove the filter by clicking **x** next to its name in the filter bar.
5. Set a filter from the map:
   1. Open a tooltip by clicking anywhere in the United States vector.
2. To show only documents where **geo.src** is **US**, click the filter icon ![filter icon](https://www.elastic.co/docs/explore-analyze/images/kibana-gs-filter-icon.png "kibana-gs-filter-icon")in the row for **ISO 3066-1 alpha-2**.
   ![Tooltip on map](https://www.elastic.co/docs/explore-analyze/images/kibana-gs_tooltip_filter.png)
   Your filtered map should look similar to this:
   ![Map showing filtered data](https://www.elastic.co/docs/explore-analyze/images/kibana-gs_map_filtered.png)


### Filter pill actions

You can interact with filter pills to edit them, temporarily alter their behavior without having to remove them, or make them available in other contexts. The following options are available when selecting a filter pill:
<definitions>
  <definition term="Pin across all apps and Unpin">
    Adds this filter to available dashboards and to apps such as **Discover**, **Lens**, **Maps**, and **Visualize**. You remove the filter if you:
    - Unpin it. In this case, the filter only remains on the currently open app, unpinned.
    - Remove it from any place while it's still pinned.
    - Refresh your session, for example by opening a dashboard in a new tab. Pinned filters are not saved along with the dashboard, visualization, or Discover session that you added them to.
    <tip>
      When a pinned filter can't be applied, for example if a field specified in the filter doesn't exist in the current data view, the filter is ignored and shows in a different color.
    </tip>
  </definition>
  <definition term="Edit filter">
    Lets you edit and update the filter.
  </definition>
  <definition term="Exclude results and Include results">
    Reverses the filter behavior.
  </definition>
  <definition term="Temporarily disable and Re-enable">
    Lets you temporarily deactivate a filter instead of requiring you to remove it. This is particularly useful for testing different filter combinations.
  </definition>
  <definition term="Delete">
    Removes the filter.
  </definition>
</definitions>

You can perform most of these actions at once for all filters in your current view using the **Filter** icon `filter`. From the menu that opens, select **Apply to all**, then choose the action you'd like to perform.

## What’s next?

- Check out [additional types of layers](https://www.elastic.co/docs/explore-analyze/visualize/maps/vector-layer) that you can add to your map.
- Learn more ways [customize your map](https://www.elastic.co/docs/explore-analyze/visualize/maps/maps-vector-style-properties).
- Learn more about [vector tooltips](https://www.elastic.co/docs/explore-analyze/visualize/maps/vector-tooltip).