﻿---
title: Create filters from a map
description: Create filters from your map to focus in on just the data you want. Maps provides three ways to create filters: Filter dashboard by map bounds, Spatial...
url: https://www.elastic.co/docs/explore-analyze/visualize/maps/maps-create-filter-from-map
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Create filters from a map
Create filters from your map to focus in on just the data you want. **Maps** provides three ways to create filters:
- [Filter dashboard by map bounds](#maps-map-extent-filter)
- [Spatial filters](#maps-spatial-filters)
- [Phrase filters](#maps-phrase-filter)


## Filter dashboard by map bounds

To filter your dashboard by your map bounds as you pan and zoom your map:
1. Go to **Dashboards**.
2. Select your dashboard from the list or click **Create dashboard**.
3. If your dashboard does not have a map, add a map panel.
4. Click the gear icon ![gear icon](https://www.elastic.co/docs/explore-analyze/images/kibana-gear_icon.png) to open the map panel menu.
5. Select **More** to view all panel options.
6. Select **Filter dashboard by map bounds**.
7. Select the checkbox for your map panel.


## Spatial filters

A spatial filter narrows search results to documents that either intersect with, are within, or do not intersect with the specified geometry.
Spatial filters have the following properties:
- **Geometry label** enables you to provide a meaningful name for your spatial filter.
- **Spatial relation** determines the [spatial relation operator](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-geo-shape-query#geo-shape-spatial-relations) to use at search time.
- **Action** specifies whether to apply the filter to the current view or to a drilldown action.

<note>
  [Drilldowns](https://www.elastic.co/docs/explore-analyze/dashboards/drilldowns) are available only if the map is a panel in a [dashboard](https://www.elastic.co/docs/explore-analyze/dashboards), and not within the Maps application.
</note>

You can create spatial filters in two ways:
- Click the tool icon ![tool icon](https://www.elastic.co/docs/explore-analyze/images/kibana-tools_icon.png), and then draw a shape, bounding box, or distance on the map to define the spatial filter.
- Click **Filter by geometry** in a [locked tooltip](/docs/explore-analyze/visualize/maps/vector-tooltip#maps-vector-tooltip-locking), and then use the feature’s geometry for the spatial filter.

![create spatial filter](https://www.elastic.co/docs/explore-analyze/images/kibana-create_spatial_filter.png)


## Phrase filters

A phrase filter narrows search results to documents that contain the specified text. You can create a phrase filter by clicking the plus icon ![gs plus icon](https://www.elastic.co/docs/explore-analyze/images/kibana-gs_plus_icon.png) in a [locked tooltip](/docs/explore-analyze/visualize/maps/vector-tooltip#maps-vector-tooltip-locking). If the map is a dashboard panel with drilldowns, you can apply a phrase filter to a drilldown by selecting the drilldown action.