﻿---
title: Import geospatial data
description: To import geospatical data into the Elastic Stack, the data must be indexed as geo_point or geo_shape. Geospatial data comes in many formats. Choose an...
url: https://www.elastic.co/docs/explore-analyze/visualize/maps/import-geospatial-data
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Import geospatial data
To import geospatical data into the Elastic Stack, the data must be indexed as [geo_point](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-point) or [geo_shape](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-shape). Geospatial data comes in many formats. Choose an import tool based on the format of your geospatial data.

## Security privileges

The Elastic Stack security features provide roles and privileges that control which users can upload files. You can manage your roles, privileges, and spaces in **Stack Management** in Kibana. For more information, see [Security privileges](https://www.elastic.co/docs/reference/elasticsearch/security-privileges), [Kibana privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges), and [Kibana role management](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/defining-roles).
To upload GeoJSON files, shapefiles, and draw features in Kibana with **Maps**, you must have:
- The `all` Kibana privilege for **Maps**
- The `all` Kibana privilege for **Index Pattern Management**
- The `create` and `create_index` index privileges for destination indices
- To use the index in **Maps**, you must also have the `read` and `view_index_metadata` index privileges for destination indices

To upload delimited files (such as CSV, TSV, or JSON files) from the **Upload file** integration, you must also have:
- The `all` Kibana privilege for **Discover**
- The `manage_pipeline` or `manage_ingest_pipelines` cluster privilege
- The `manage` index privilege for destination indices


## Upload delimited files with latitude and longitude columns

You can upload a file and import it into an Elasticsearch index with latitude and longitude columns combined into a `geo_point` field.
1. Go to the **Integrations** page and select **Upload file**.
2. Select a file in one of the supported file formats.
3. Click **Import**.
4. Select the **Advanced** tab.
5. Set **Index name**.
6. If a combined `geo_point` field is not created automatically, click **Add combined field**, then click **Add geo point field**.
7. Fill out the form and click **Add**.
8. Click **Import**.


## Upload a GeoJSON file

**Upload file** indexes GeoJSON features in Elasticsearch, creating a document for each feature.
<note>
  GeoJSON feature coordinates must be in EPSG:4326 coordinate reference system. For data using other coordinate systems, refer to our [conversion instructions](/docs/explore-analyze/visualize/maps/maps-clean-data#_convert_to_wgs84_coordinate_reference_system).
</note>

1. [Create a new map](/docs/explore-analyze/visualize/maps/maps-getting-started#maps-create).
2. Click **Add layer**.
3. Select **Upload file**.
4. Use the file chooser to select a GeoJSON file with the extension `.json` or `.geojson`.
5. Click **Import file**.


## Upload a shapefile

**Upload file** indexes shapefile features in Elasticsearch, creating a document for each feature.
1. [Create a new map](/docs/explore-analyze/visualize/maps/maps-getting-started#maps-create).
2. Click **Add layer**.
3. Select **Upload file**.
4. Use the file chooser to select the `.shp` file from your shapefile folder.
5. Use the `.dbf` file chooser to select the `.dbf` file from your shapefile folder.
6. Use the `.prj` file chooser to select the `.prj` file from your shapefile folder.
7. Use the `.shx` file chooser to select the `.shx` file from your shapefile folder.
8. Click **Import file**.


## Draw features in a map

Upload features into Elasticsearch by drawing lines, polygons, circles, bounding boxes, and points in a map.
To create a new index for drawing:
1. [Create a map](/docs/explore-analyze/visualize/maps/maps-getting-started#maps-create).
2. Click **Add layer**.
3. Select **Create index**.
4. Set **Index name**.
5. Click **Create index**.

To open an existing index for drawing:
1. [Create a map](/docs/explore-analyze/visualize/maps/maps-getting-started#maps-create).
2. Click **Add layer**.
3. Select **Documents**.
4. Select the data view that points to your index. A [data view](https://www.elastic.co/docs/explore-analyze/find-and-organize/data-views) can point to one or more indices. For feature editing, the data view must point to a single index.
5. Click **Add and close**.
6. In the legend, click the layer name and select **Edit features**.

When feature editing is open, a feature editing toolbox is displayed on the left side of the map.
![drawing layer](https://www.elastic.co/docs/explore-analyze/images/kibana-drawing_layer.png)

To draw features:
1. Click on the line, polygon, circle, bounding box, or point icon.
2. Move the mouse cursor over the map and follow the on screen instructions to draw a feature.
   When a feature is complete, the feature is added to the index as a new document.
3. Repeat to draw additional features.
4. When you are finished adding features, go to the legend, and click **Exit** under the layer name.


## Upload data with IP addresses

The GeoIP processor adds information about the geographical location of IP addresses. See [GeoIP processor](https://www.elastic.co/docs/reference/enrich-processor/geoip-processor) for details. For private IP addresses, see [Enriching data with GeoIPs from internal, private IP addresses](https://www.elastic.co/blog/enriching-elasticsearch-data-geo-ips-internal-private-ip-addresses).

## Upload data with GDAL

[GDAL](https://www.gdal.org/) (Geospatial Data Abstraction Library) contains command line tools that can convert geospatial data between 75 different geospatial file formats and index that geospatial data into Elasticsearch. See [Ingest geospatial data into Elasticsearch with GDAL](https://www.elastic.co/blog/how-to-ingest-geospatial-data-into-elasticsearch-with-gdal) for details.