﻿---
title: Heat map layer
description: Heat map layers cluster point data to show locations with higher densities. To add a heat map layer to your map, click Add layer, then select Heat map...
url: https://www.elastic.co/docs/explore-analyze/visualize/maps/heatmap-layer
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Heat map layer
Heat map layers cluster point data to show locations with higher densities.
![heatmap layer](https://www.elastic.co/docs/explore-analyze/images/kibana-heatmap_layer.png)

To add a heat map layer to your map, click **Add layer**, then select **Heat map**. The index must contain at least one field mapped as [geo_point](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-point) or [geo_shape](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-shape).
<note>
  Only count, sum, unique count metric aggregations are available with the grid aggregation source and heat map layers. Average, min, and max are turned off because the heat map will blend nearby values. Blending two average values would make the cluster more prominent, even though it just might literally mean that these nearby areas are average.
</note>