﻿---
title: Maps
description: Create beautiful maps from your geographical data. With Maps, you can: Build maps with multiple layers and indices.Animate spatial temporal data.Upload...
url: https://www.elastic.co/docs/explore-analyze/visualize/maps
products:
  - Elastic Cloud Serverless
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Maps
Create beautiful maps from your geographical data. With **Maps**, you can:
- Build maps with multiple layers and indices.
- Animate spatial temporal data.
- Upload GeoJSON files and shapefiles.
- Embed your map in dashboards.
- Symbolize features using data values.
- Focus on only the data that’s important to you.


## Build maps with multiple layers and indices

Use multiple layers and indices to show all your data in a single map. Show how data sits relative to physical features like weather patterns, human-made features like international borders, and business-specific features like sales regions. Plot individual documents or use aggregations to plot any data set, no matter how large.
![sample data ecommerce](https://www.elastic.co/docs/explore-analyze/images/kibana-sample_data_ecommerce.png)

To learn about specific types of layers, check out [Heat map layer](https://www.elastic.co/docs/explore-analyze/visualize/maps/heatmap-layer), [Tile layer](https://www.elastic.co/docs/explore-analyze/visualize/maps/tile-layer), and [Vector layer](https://www.elastic.co/docs/explore-analyze/visualize/maps/vector-layer).

## Animate spatial temporal data

Data comes to life with animation. Hard to detect patterns in static data pop out with movement. Use time slider to animate your data and gain deeper insights.
This animated map uses the time slider to show Portland buses over a period of 15 minutes. The routes come alive as the bus locations update with time.
![timeslider](https://www.elastic.co/docs/explore-analyze/images/kibana-timeslider.gif)

To create this type of map, check out [Track, visualize, and alert assets in real time](https://www.elastic.co/docs/explore-analyze/visualize/maps/asset-tracking-tutorial).

## Upload GeoJSON files and shapefiles

Use **Maps** to drag and drop your GeoJSON and shapefile data into Elasticsearch, and then use them as layers in your map.

## Embed your map in dashboards

Viewing data from different angles provides better insights. Dimensions that are obscured in one visualization might be illuminated in another. Add your map to a [Dashboard](https://www.elastic.co/docs/explore-analyze/dashboards) and view your geospatial data alongside bar charts, pie charts, tag clouds, and more.
This choropleth map shows the density of non-emergency service requests in San Diego by council district. The map is embedded in a dashboard, so users can better understand when services are requested and gain insight into the top requested services.
![embed in dashboard](https://www.elastic.co/docs/explore-analyze/images/kibana-embed_in_dashboard.jpeg)


## Symbolize features using data values

Customize each layer to highlight meaningful dimensions in your data. For example, use dark colors to symbolize areas with more web log traffic, and lighter colors to symbolize areas with less traffic.

## Focus on only the data that’s important to you

Search across the layers in your map to focus on just the data you want. Combine free text search with field-based search using the [Kibana Query Language](https://www.elastic.co/docs/explore-analyze/query-filter/languages/kql). Set the time filter to restrict layers by time. Draw a polygon on the map or use the shape from features to create spatial filters. Filter individual layers to compares facets.
Check out [Search geographic data](https://www.elastic.co/docs/explore-analyze/visualize/maps/maps-search).