﻿---
title: Image panels
description: To personalize your dashboards, add your own logos and graphics with the Image panel. You can upload images from your computer, select previously uploaded...
url: https://www.elastic.co/docs/explore-analyze/visualize/image-panels
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Image panels
To personalize your dashboards, add your own logos and graphics with the **Image** panel.
<important>
  Image uploads are limited to 10 MiB.
</important>

You can upload images from your computer, select previously uploaded images, or add images from an external link.
1. From your dashboard, select **Add panel**.
2. In the **Add panel** flyout, select **Image**. The **Add image** flyout appears and lets you add and configure the image you want to display.
3. Add your image and configure the settings, and then click **Save**.

![Add image editor](https://www.elastic.co/docs/explore-analyze/images/kibana-dashboard_addImageEditor_8.7.0.png)

To manage your uploaded image files, go to the **Files** management page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
<warning>
  When you export a dashboard, the uploaded image files are not exported. When importing a dashboard with an image panel, and the image file is unavailable, the image panel displays a `not found` warning. Such panels have to be fixed manually by re-uploading the image using the panel’s image editor.
</warning>