﻿---
title: ES|QL visualizations
description: You can add ES|QL visualizations to a dashboard directly from queries in Discover, or you can start from a dashboard. In Discover, typing ES|QL queries...
url: https://www.elastic.co/docs/explore-analyze/visualize/esorql
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# ES|QL visualizations
You can add ES|QL visualizations to a dashboard directly from queries in Discover, or you can start from a dashboard.

## Edit and add from Discover

In Discover, [typing ES|QL queries](https://www.elastic.co/docs/explore-analyze/query-filter/languages/esql-kibana) automatically shows a visualization. The visualization type depends on the content of the query: histogram, bar charts, etc. You can manually make changes to that visualization and edit its type and display options using the pencil button ![pencil button](https://www.elastic.co/docs/explore-analyze/images/kibana-esql-icon-edit-visualization.svg).
You can then **Save** and add it to an existing or a new dashboard using the save button of the visualization ![save button](https://www.elastic.co/docs/explore-analyze/images/kibana-esql-icon-save-visualization.svg).

## Create from dashboard

1. Add a new panel from your dashboard.
   - <applies-to>Elastic Cloud Serverless: Generally available</applies-to> <applies-to>Elastic Stack: Generally available since 9.2</applies-to> Select **Add** > **New panel** in the toolbar.
- <applies-to>Elastic Stack: Generally available from 9.0 to 9.1</applies-to> Click **Add panel** in the dashboard toolbar.
   <tip>
   If you haven't created a [data view](https://www.elastic.co/docs/explore-analyze/find-and-organize/data-views) and you don't have a dashboard yet, the **Dashboards** page offers you the possibility to **Try ESQL** right away. By selecting this option, a dashboard is created with an ESQL visualization that you can interact with and configure using ESQL.
   </tip>
2. Choose **ESQL** under **Visualizations**. An ESQL editor appears and lets you configure your query and its associated visualization. The **Suggestions** panel can help you find alternative ways to configure the visualization.
   <tip>
   Check the [ES|QL reference](https://www.elastic.co/docs/reference/query-languages/esql) to get familiar with the syntax and optimize your query.
   </tip>
3. When editing your query or its configuration, run the query to update the preview of the visualization.
   ![Previewing an ESQL visualization](https://images.contentstack.io/v3/assets/bltefdd0b53724fa2ce/blt69dcceb4f1e12bc1/66c752d6aff77d384dc44209/edit-esql-visualization.gif)
   <note applies-to="Elastic Cloud Serverless: Generally available, Elastic Stack: Generally available since 9.1">
   When you edit the query and run it again, the visualization configuration persists as long as it is compatible with the query changes. Refer to [ES|QL visualizations > Chart configuration persistence over ES|QL query update](#chart-config-persist) for more details.
   </note>
4. You can bind controls to your ESQL visualizations in dashboards by creating [ES|QL controls](/docs/explore-analyze/dashboards/add-controls#add-variable-control).
5. Select **Apply and close** to save the visualization to the dashboard.


### Customize the appearance of your ES|QL visualization

When editing an ES|QL visualization, you can customize the appearance of the chart. To do that:
1. Click one of the fields representing an axis of the chart to open its details.
   ![Click on the axis field to open its details](https://www.elastic.co/docs/explore-analyze/images/esql-visualization-customize-axis.png)
2. Define the appearance of your choice from the available options.
   ![Appearance customization options for ESQL charts](https://www.elastic.co/docs/explore-analyze/images/esql-visualization-customization-options.png)
3. Return to the previous menu, then **Apply and close** the configuration to save your changes.


### Chart configuration persistence over ES|QL query update

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.1
</applies-to>

When you edit the ES|QL query and run it again, the visualization configuration persists as you defined it as long as it is compatible with the query changes.
The chart configuration resets or follows automatic suggestions when:
- <applies-to>Elastic Stack: Generally available since 9.2</applies-to> You manually select a different chart type incompatible with the one previously selected.
- <applies-to>Elastic Stack: Generally available since 9.2</applies-to> You create a new chart and haven't edited the visualization's options yet.
- The query changes significantly and no longer returns compatible columns.


## Create an alert from your ES|QL visualization

<applies-to>
  - Serverless Elasticsearch projects: Generally available
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Unavailable
  - Elastic Stack: Generally available since 9.1
</applies-to>

Once you've created an ES|QL panel, you can create an Elasticsearch threshold rule directly from the visualization panel, based on the data it displays. When you do this, the rule query is automatically generated and either describes the data and sets a specific threshold, or describes the data without setting a specific threshold.
<note>
  Elastic Security rule types are not supported.
</note>

To create a rule with the threshold pre-specified:
- Right-click a data point in the visualization and click **Add alert rule**. This opens the **Create rule** flyout. The generated query will define a threshold that corresponds to the data point you selected.
- [Configure](https://www.elastic.co/docs/solutions/observability/incident-management/create-an-elasticsearch-query-rule) your Elasticsearch rule.

To create a rule without the threshold pre-specified:
- Open the **More actions** (three dots) menu in the upper right of the panel and select **Add alert rule**. This opens the **Create rule** flyout. The generated query will define a threshold that corresponds to the data point you selected.
- [Configure](https://www.elastic.co/docs/solutions/observability/incident-management/create-an-elasticsearch-query-rule) your Elasticsearch rule.


## Use emojis in visualizations

ES|QL query results can include emoji characters, which means you can use them in your ES|QL visualizations. Combined with `EVAL` and `CASE` functions, this opens up options like mapping values to colored status indicators (🟢, 🟠, 🔴), adding visual labels, or highlighting specific categories.
This example uses the Kibana sample web logs data to build a status table that shows the success rate per host, with a colored status indicator.
![Table visualization showing success rate per host with emoji status indicators](https://www.elastic.co/docs/explore-analyze/images/esql-table-emoji.png)

<tip>
  Because they're part of the query results, you can use them in any visualization type that displays text fields, such as bar charts with emoji labels or metric panels with status indicators.
</tip>

Before you begin, ensure you have the sample web logs data installed. In Kibana, go to **Integrations** and search for **Sample data**. On the **Sample data** page, expand the **Other sample data sets** section and add **Sample web logs**.
To create the visualization:
1. Open a dashboard and add a new ES|QL visualization:
   - <applies-to>Elastic Cloud Serverless: Generally available</applies-to> <applies-to>Elastic Stack: Generally available since 9.2</applies-to> Select **Add** > **New panel** in the toolbar, then choose **ES|QL** under **Visualizations**.
- <applies-to>Elastic Stack: Generally available from 9.0 to 9.1</applies-to> Click **Add panel** in the dashboard toolbar, then choose **ES|QL**.
2. Enter the following query:
   ```esql
   FROM kibana_sample_data_logs
   | EVAL is_success = CASE(response >= "200" AND response < "300", 1, 0) 
   | STATS 
       total_requests = COUNT(*),
       successful_requests = SUM(is_success)
     BY host.keyword 
   | EVAL success_rate = ROUND(successful_requests * 100.0 / total_requests, 1) 
   | EVAL status = CASE( 
       success_rate >= 92, "🟢",
       success_rate >= 90, "🟠",
       "🔴"
     )
   | KEEP host.keyword, status, success_rate, successful_requests, total_requests 
   | SORT success_rate DESC
   ```
   1. Create a binary flag: 1 for successful responses (2xx), 0 otherwise.
2. Group by host and use `SUM` to count successes.
3. Calculate the success rate as a percentage.
4. Map the success rate to emoji indicators based on thresholds.
5. Select and order the columns for the table output.
3. Run the query. A visualization appears with one row per host and an emoji status column. If Kibana suggests a different visualization type, select **Table** from the visualization type dropdown.
4. Optionally, configure the table appearance in the visualization settings:
   - To reorder columns, rearrange the metrics in the **Metrics** section.
- To rename a column, select the metric and update its **Name** in the appearance options.
5. Select **Apply and close** to save the visualization to your dashboard.
6. Optionally, once the panel is saved, select the panel title to give it a meaningful name like `Status per host`.

Once you have your visualization working, you can add [controls](/docs/explore-analyze/dashboards/add-controls#add-variable-control) to filter by host or time range, use [LOOKUP JOIN](https://www.elastic.co/docs/reference/query-languages/esql/esql-lookup-join) to enrich your data with metadata from other indices, or create [alerts](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/rule-type-es-query) based on the same query to get notified when status changes.