﻿---
title: Build metric charts with Kibana
description: Instructions and best practices for building metric charts with Kibana Lens in Elastic.
url: https://www.elastic.co/docs/explore-analyze/visualize/charts/metric-charts
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Build metric charts with Kibana
Metric charts make important single values stand out on a dashboard. They're perfect for highlighting KPIs such as error rates or SLOs, and for making them understandable at a glance with dynamic coloring or trend indicators.
They work with any numeric data: plain numbers, percentages, or calculations like a count, sum, or average. You can get this numeric data from numeric fields stored in your Elasticsearch documents, or from aggregation functions and formulas that you can apply to any type of field. 
You can also display strings by using the `Last value` aggregation function that picks up the last document, sorted by timestamp, in the current time frame.
You can create metric charts in Kibana using [**Lens**](https://www.elastic.co/docs/explore-analyze/visualize/lens).
![Metric chart representing an SLO with different layouts](https://www.elastic.co/docs/explore-analyze/images/metric-chart.png)

## Build a metric chart

To build a metric chart:
<stepper>
  <step title="Access Lens">
    **Lens** is Kibana's main visualization editor. You can access it:
    - From a dashboard: On the **Dashboards** page, open or create the dashboard where you want to add a metric chart, then add a new visualization.
    - From the **Visualize library** page by creating a new visualization..
  </step>

  <step title="Set the visualization to Metric">
    New visualizations default to creating **Bar** charts.Using the dropdown indicating **Bar**, select **Metric**.
  </step>

  <step title="Define the data to show">
    1. Select the data view that contains your data.
    2. Define the **Primary metric** by dragging a field from the fields list to the chart. Kibana automatically selects an appropriate aggregation function like Sum, Average, or Count based on the field type. This is the only setting that your metric chart requires to display something.
    3. Optionally:
       - Add a [secondary metric](#secondary-metric-options). You can use this secondary metric as a comparison value or as a trend indicator to show how the primary metric evolves over time.
    - Specify a [maximum value](#max-value-options).
    - [Break down](#breakdown-options) the metric into multiple tiles based on another dimension.
    Refer to [Build metric charts with Kibana > Metric chart settings](#settings) to find all data configuration options for your metric chart.
  </step>

  <step title="Customize the chart to follow best practices">
    Tweak the appearance of the chart to your needs. Consider the following best practices:
    <definitions>
      <definition term="Use color wisely">
        Assign colors that match your users' expectations and consider your specific context.
      </definition>
      <definition term="Format for readability">
        Round to an appropriate precision. Showing 1.2M is clearer than 1,234,567.89 for high-level metrics, but use more precision when small changes matter.
      </definition>
      <definition term="Provide context">
        Use titles and subtitles to explain what the metric shows. "45,234" is a number, but "Active Users" as a title gives it meaning, and "Last 24 hours" as a subtitle makes it unambiguous.
      </definition>
    </definitions>
    Refer to [Build metric charts with Kibana > Metric chart settings](#settings) for a complete list of options.
  </step>

  <step title="Save the chart">
    - If you accessed Lens from a dashboard, select **Save and return** to save the visualization and add it to that dashboard, or select **Save to library** to add the visualization to the Visualize library and be able to add it to other dashboards later.
    - If you accessed Lens from the Visualize library, select **Save**. A menu opens and offers you to add the visualization to a dashboard and to the Visualize library.
  </step>
</stepper>


## Advanced metric scenarios


### Show trends in Metric charts

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.1
</applies-to>

When creating **Metric** visualizations with numeric data, you can add trend indicators that compare your primary metric to a secondary value. This feature displays colored badges with directional arrows to help you quickly identify whether values are increasing, decreasing, or staying the same.

| Without trend                                                                                                                         | With trend                                                                                                                          |
|---------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------|
| ![Secondary metric before comparison](https://www.elastic.co/docs/explore-analyze/images/secondary_metric_before_compare.png "title") | ![Secondary metric after comparison](https://www.elastic.co/docs/explore-analyze/images/secondary_metric_after_compare.png "title") |

To add trend indicators to your metric visualization:
1. Create a **Metric** visualization with a numeric primary metric.
2. Add a secondary metric that represents the comparison value.
   <tip>
   Use the `shift` parameter in formulas to compare current values against historical data. For example, if your primary metric is counting orders (based on an `order_id` field) for the current week, you can use the `count(order_id, shift='1w')` formula to compare this week's count of orders to last week's count.
   </tip>
3. In the secondary metric configuration, look for the **Color by value** option. The possible choices are:
   - **None**: No trend indicators (default)
- **Static**: Shows the secondary metric as a badge with a fixed color that you select
- **Dynamic**: Enables both color coding and directional icons based on the comparison
4. Select **Dynamic** coloring. More options appear.
   ![Dynamic coloring options for secondary metrics](https://www.elastic.co/docs/explore-analyze/images/metric-secondary-dynamic-coloring.png)
5. Choose a **Color palette** that matches how you'd like to represent the comparison.
6. Configure the **Display** option:
   - **Icon**: Shows only directional arrows: ↑ for increase, ↓ for decrease, = for no change
- **Value**: Shows only the secondary metric value
- **Both**: Shows both the icon and value (default)
7. The secondary metric does not automatically compare with the primary metric. Define the value for **Compare to**:
   - **Static value**: Compares against a fixed baseline value that you specify
- **Primary metric**: Compares the secondary metric directly against the primary metric by displaying the result of `Primary metric - Secondary metric`. This option is only available when the primary metric is numeric.
  When you select this option, the secondary metric is automatically updated:
  - The secondary metric label changes to **Difference**. You can edit this label.
- If you chose a **Display** option that shows a value, the secondary metric value is automatically updated to show the difference compared to the primary metric.
8. Apply your changes.

The metric visualization now shows the secondary metric as a comparison with a trend indicator.

### Show progress by setting a maximum value

When creating **Metric** visualizations with numeric data, you can specify a maximum value to show progress toward a goal or capacity limit. When combined with the **Bar** background chart option, this displays a progress bar that visually represents how close your current metric is to reaching the maximum value.

| Without progress                                                                                                | With progress                                                                                         |
|-----------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------|
| ![Metric before showing progress](https://www.elastic.co/docs/explore-analyze/images/metric-no-max.png "title") | ![Metric showing progress](https://www.elastic.co/docs/explore-analyze/images/metric-max.png "title") |

To add a progress bar to your metric visualization:
1. Create a **Metric** visualization with a numeric primary metric.
2. Optionally, [customize the appearance of the metric](#primary-metric-options). For example, add dynamic coloring to the primary metric to change colors based on progress: red when below 50%, yellow between 50-80%, and green above 80%. The progress bar will reflect this configuration once you set up a maximum value.
3. Add a maximum value that represents your goal or upper limit. The [maximum value](#max-value-options) can be a static value, a function, or a formula based on your data.
   ![Metric maximum value option](https://www.elastic.co/docs/explore-analyze/images/metric-maximum-value.png "title")
4. Configure the **Primary metric** appearance to show the progress bar. Depending on the configuration of the primary metric, Lens might automatically set this option for you. If not, complete these steps:
   1. In the primary metric configuration, set the **Background chart** or **Supporting visualization** type to **Bar**. The name of this option depends on the version you're using.
2. Optionally, change the orientation of the progress bar as needed.
5. Apply your changes.

The metric visualization now shows a progress bar indicating how close the current value is to the maximum.
<tip>
  You can combine progress bars with secondary metrics to show both progress toward a goal and trends over time. To do this, add both a maximum value and a secondary metric to your visualization.
</tip>


## Metric chart settings

Customize your metric chart to display exactly the information you need, formatted the way you want.

### Primary metric settings

<definitions>
  <definition term="Value">
    The main numeric value that appears prominently in your chart. When you drag a field onto the chart, Kibana suggests a function based on the field type. You can change it and use aggregation functions like `Sum`, `Average`, `Count`, `Median`, and more, or create custom calculations with formulas. Refer to [Lens > Use formulas to perform math](/docs/explore-analyze/visualize/lens#lens-formulas) for examples, or to the `documentation` **Formula reference** available from Lens.
    <dropdown title="Advanced settings">
      Depending on the data you defined, several options allow you to apply additional filtering to the data taken into account to compute the final value to show.Based on the type of visualization you're creating, only some of the following options can be available:
      - **Normalize by unit**: Normalize the metric values to show per unit of time.
      - **Filter by**: Specify a query.
      - **Reduced time range**: Reduce the time range specified on the dashboard's time filter by the specified duration.
      - **Time shift**: Shift the time range by the specified duration. This is useful if the value should use a different time range than the one selected on the dashboard.
      - **Hide zero values**: Don't show values equal to zero. This option is on by default.
    </dropdown>
  </definition>
  <definition term="Appearance">
    Define the formatting of the primary metric, including:
    - **Name**: By default, the chart uses the function or formula as title. It's a best practice to customize this with a meaningful title.
    - **Value format**: Choose to display the metric as number, percent, bytes, bits, duration, or with a custom format that you can define.
    - **Icon decoration**: Add an icon to the top right corner of the chart.
    - **Background chart** or supporting visualization **Type** (depending on your version): Options include:
      - **None**: Show a unified background.
    - **Line**: Show a light line chart in the background.
    - **Bar**: Show a progress bar that represents the current value of the chart measured against the [Maximum value](#max-value-options) defined for the chart.
    - **Bar orientation**: Options include **Vertical** and **Horizontal**.
    - **Color mode** or **Color by value** (depending on your version): Apply colors to the chart. Choose between **Static** for a unique color and **Dynamic** for using different colors based on the metric's value. By default, the color applies to the chart's background.
      - **Static**: The color always remains the same and is independent from the metric's value.
      - **Color**: Pick a color and its opacity.
    - **Dynamic**: Define colors to apply to the chart based on the value of the primary metric.
      - **Dynamic color mapping**: Use the color palette to define custom color ranges.
  </definition>
</definitions>


### Secondary metric settings

<definitions>
  <definition term="Value">
    An optional additional value that provides context or enables comparisons. Common uses include:
    - Time-shifted values to show trends (for example, last week's sales compared to this week)
    - Different aggregations on the same data (for example, showing both average and median response times)
    - Related metrics for context (for example, showing total count alongside an average)
    <dropdown title="Advanced settings">
      Depending on the data you defined, several options allow you to apply additional filtering to the data taken into account to compute the final value to show.Based on the type of visualization you're creating, only some of the following options can be available:
      - **Normalize by unit**: Normalize the metric values to show per unit of time.
      - **Filter by**: Specify a query.
      - **Reduced time range**: Reduce the time range specified on the dashboard's time filter by the specified duration.
      - **Time shift**: Shift the time range by the specified duration. This is useful if the value should use a different time range than the one selected on the dashboard.
      - **Hide zero values**: Don't show values equal to zero. This option is on by default.
    </dropdown>
  </definition>
  <definition term="Appearance">
    Define the formatting of the secondary metric, including:
    - **Name**: By default, the chart uses the function or formula as title. It's a best practice to customize this with a meaningful title.
    - **Value format**: Choose to display the metric as number, percent, bytes, bits, duration, or with a custom format that you can define.
    - **Label**: Define the label displayed next to the secondary metric. By default, the **Name** shows. You can instead show a **Custom** value or hide it by selecting **None**.
    - **Label position**: Choose to show the label **Before** or **After** the metric.
    - **Color by value**: Apply colors to the chart. Choose between **None**, **Static** for a unique color and **Dynamic** for using different colors based on the metric's value. This option allows you to use the secondary metric as a comparison point to highlight trends. Refer to [Build metric charts with Kibana > Show trends in Metric charts](#metric-trends) for more details.
  </definition>
</definitions>


### Maximum value settings

<definitions>
  <definition term="Value">
    An optional reference value that defines the upper bound for your metric. Specifying a maximum lets you show a progress bar in your metric chart. The progress is represented by your primary metric's value on a scale of 0 to the defined maximum value. This option is useful for showing progress toward goals or capacity limits.
    <note>
      If a progress bar doesn't show after setting a maximum value, manually set the primary metric's **Background chart** option to **Bar**.
    </note>
    <dropdown title="Advanced settings">
      Depending on the data you defined, several options allow you to apply additional filtering to the data taken into account to compute the final value to show.Based on the type of visualization you're creating, only some of the following options can be available:
      - **Normalize by unit**: Normalize the metric values to show per unit of time.
      - **Filter by**: Specify a query.
      - **Reduced time range**: Reduce the time range specified on the dashboard's time filter by the specified duration.
      - **Time shift**: Shift the time range by the specified duration. This is useful if the value should use a different time range than the one selected on the dashboard.
      - **Hide zero values**: Don't show values equal to zero. This option is on by default.
    </dropdown>
  </definition>
  <definition term="Appearance">
    Define the formatting of the maximum value, including:
    - **Name**: It's a best practice to customize this with a readable title.
  </definition>
</definitions>


### Breakdown settings

<definitions>
  <definition term="Data">
    Split your metric into multiple tiles based on a categorical field. Each unique value creates its own tile, allowing you to compare metrics across regions, products, time periods, or any other dimensions. You can optionally specify the following options:
    - **Number of values**: The number of tiles to show. If more values are available for the selected breakdown field, an additional tile named **Other** shows if the **Group remaining values as "Other"** advanced option is on.
    - **Rank by**: The dimension by which top values are ranked.
    - **Rank direction**: The direction to use for the ranking.
    - **Collapse by**: Aggregate values of the various tiles into a single number. Possible aggregation options are `None` (default), `Sum`, `Average`, `Min`, and `Max`.
    <dropdown title="Advanced settings">
      Several advanced options allow you to refine the behavior of the breakdown:
      - **Include documents without the selected field**: Off by default.
      - **Group remaining values as "Other"**: On by default.
      - **Enable accuracy mode**: This option improves results for high-cardinality data, but increases the load on the Elasticsearch cluster.
      - **Include values**: Values from the breakdown dimension to always show a tile for.
      - **Exclude values**: Values from the breakdown dimension to always exclude from the displayed tiles.
    </dropdown>
  </definition>
  <definition term="Appearance">
    Define the formatting of the broken down view of the metric, including:
    - **Name**: It's a best practice to customize this with a meaningful title.
    - **Layout columns**: The number of columns used to lay out the various tiles of your metric chart.
  </definition>
</definitions>


### General layout settings

<applies-to>
  - Elastic Stack: Generally available since 9.2
</applies-to>

When creating or editing a visualization, you can customize several appearance options. To do that, look for the `brush` icon.
<definitions>
  <definition term="Primary metric">
    Define the formatting of the primary metric in terms of **Position**, **Alignment**, and **Font size**.
  </definition>
  <definition term="Title and subtitle">
    Enter a subtitle and define the relevant **Alignment** and **Font weight**.
  </definition>
  <definition term="Secondary metric">
    Define the **Alignment** of the secondary metric.
  </definition>
  <definition term="Other">
    Choose the **Icon** position.
  </definition>
</definitions>


## Metric chart examples

The following examples show various configuration options that you can use for building impactful metrics.
<definitions>
  <definition term="Ratio of successful requests">
    Display the percentage of successful requests on a monitoring dashboard:
    - **Title**: "Successful requests (2xx)"
    - **Primary metric**: `count(kql='response.code >= "200" and response.code < "300"') / count(response.code)`
      - **Value format**: `Percent`
    - **Color mode** or **Color by value**: `Dynamic` (green when above 95%, yellow between 75% and 95%, red when below)
    - **Background chart** or **Supporting visualization**: "Line" to show evolution over time
    - **Secondary metric**: `0.95` formula
      - **Value format**: `Percent`
    - **Label**: Custom, set to `Target:`
    ![Metric with below target successful request percentage](https://www.elastic.co/docs/explore-analyze/images/metric-example-successful-requests-rate.png)
  </definition>
  <definition term="Ratio of successful requests per origin">
    This example builds on the previous one to display the percentage of successful requests for the 10 countries with the most incoming requests on a monitoring dashboard:
    - **Title**: "Successful requests (2xx)"
    - **Primary metric**: `count(kql='response.code >= 200 and response.code < 300') / count(response.code)`
      - **Value format**: `Percent`
    - **Color mode** or **Color by value**: `Dynamic`. Green when above 95%, yellow between 75% and 95%, red when below
    - **Background chart** or **Supporting visualization**: "Line" to show evolution over time
    - **Secondary metric**: `0.95` formula
      - **Name**: `Target:`
    - **Value format**: `Percent`
    - **Break down by**: `geo.dest`
      - **Number of values**: `10`
    - **Rank by**: `Custom` > `Count` > `Records` to get countries generating most requests
    ![Metric with below target successful request percentage](https://www.elastic.co/docs/explore-analyze/images/metric-example-successful-requests-rate-top-countries.png)
  </definition>
  <definition term="Website traffic with trend">
    Monitor current traffic and show whether it's increasing or decreasing compared to the previous period:
    - **Title**: "Weekly page views"
    - **Primary metric**: `count()` (current week's page views)
    - **Secondary metric**: `count(shift='1w')` (previous week's page views)
      - **Color mode** or **Color by value**: Dynamic coloring
    - **Compare to**: Primary metric
    - **Display**: Both icon and value
    - **Label**: "Compared to previous week"
    - **Color palette**: Green for increases (more traffic is positive)
    ![Metric showing weekly visits with weekly comparison trend](https://www.elastic.co/docs/explore-analyze/images/metric-website-views-weekly-trend-example.png)
  </definition>
</definitions>