﻿---
title: Build line charts with Kibana
description: Instructions and best practices for building line charts with Kibana Lens in Elastic.
url: https://www.elastic.co/docs/explore-analyze/visualize/charts/line-charts
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Build line charts with Kibana
Line charts are ideal for visualizing how metrics evolve over time, spotting seasonal patterns, and detecting spikes or regressions at a glance. Use them for KPIs like response time, error rate, throughput, or utilization, and compare multiple series or previous periods on the same chart. You can create line charts from any numeric data using aggregations (for example, `Average`, `Percentile`, `Counter rate`) or with custom [formulas](/docs/explore-analyze/visualize/lens#lens-formulas).
You can create line charts in Kibana using [**Lens**](https://www.elastic.co/docs/explore-analyze/visualize/lens).
![Example Lens line chart](https://www.elastic.co/docs/explore-analyze/images/kibana-line-new.png)

## Build a line chart

To build a line chart:
<stepper>
  <step title="Access Lens">
    **Lens** is Kibana's main visualization editor. You can access it:
    - From a dashboard: On the **Dashboards** page, open or create the dashboard where you want to add a line chart, then add a new visualization.
    - From the **Visualize library** page by creating a new visualization.
  </step>

  <step title="Set the visualization to Line">
    New visualizations default to **Bar**.Using the visualization type dropdown, select **Line**.
  </step>

  <step title="Define the data to show">
    1. Select the data view that contains your data.
    2. Drag a [time field](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/date) to the **Horizontal axis** and a numeric field to the **Vertical axis**. Kibana automatically selects an appropriate aggregation function compatible with the selected field.
    Optionally:
    - Add more numeric fields to create additional series, or drag a categorical field to **Break down by** to split the series.
    - You can click the **Add layer** icon `plus_in_square` to integrate additional visualizations, [annotations](/docs/explore-analyze/visualize/lens#add-annotations), or a [reference line](/docs/explore-analyze/visualize/lens#add-reference-lines).
  </step>

  <step title="Customize the chart to follow best practices">
    You can tweak the appearance of your chart by adjusting axes, legends, and series styles from the chart settings. Consider the following best practices:
    <definitions>
      <definition term="Use color wisely">
        Assign colors that match your users' expectations and consider your specific context.
      </definition>
      <definition term="Provide context">
        Add a legend and descriptive axis titles, or remove them for obvious axes.
      </definition>
    </definitions>
    For layout, hierarchy, and color guidance on dashboards, check EUI’s [Dashboard good practices](https://eui.elastic.co/docs/dataviz/dashboard-good-practices/).
    For more chart configuration options, go to the [Line chart settings](#settings) section.
  </step>

  <step title="Save the chart">
    - If you accessed Lens from a dashboard, select **Save and return** to save the visualization and add it to that dashboard, or select **Save to library** to add the visualization to the Visualize library.
    - If you accessed Lens from the Visualize library, select **Save**. The Save menu also lets you add the visualization to a dashboard and the Visualize library.
  </step>
</stepper>


## Advanced line scenarios


### Compare current versus previous period with time shift

In line charts, you can enable time shift to compare the current value with a prior time range and identify deltas.
![Example Lens line chart current previous](https://www.elastic.co/docs/explore-analyze/images/kibana-line-current-previous.png)
1. Create a line chart with a time-based **Horizontal axis** and your main metric on **Vertical axis**, for example: `bytes`.
2. Duplicate the layer:
   - <applies-to>Elastic Cloud Serverless: Generally available</applies-to> <applies-to>Elastic Stack: Generally available since 9.3</applies-to> Select `copy` **Duplicate layer** from the visualization editor.
- <applies-to>Elastic Stack: Generally available from 9.0 to 9.2</applies-to> Open the `boxes_vertical` contextual menu of the visualization editor and select `copy` **Duplicate layer**.
3. From the duplicated layer settings, select the field defined as vertical axis to open its details. Expand its **Advanced** options and set **Time shift** to `1w` or to the time value of your choice.
   Check [Compare differences over time](/docs/explore-analyze/visualize/lens#compare-data-with-time-offsets) for more details.
4. Optionally, customize the appearance of the layer to adjust how it looks on the chart. When you duplicate a layer, Kibana automatically assigns a different **Series color** to the new layer. You can for example change this color, or adjust the layer's name and axis position. This name is used for the chart's legend.

<tip>
  You can also compute the relative change by defining the axis data with a [formula](/docs/explore-analyze/visualize/lens#lens-formulas), for example:

  `(average(bytes) - average(bytes, shift='1w')) / average(bytes, shift='1w')`
</tip>


### Highlight thresholds with reference lines

Use reference lines to indicate important thresholds, such as SLOs or alert limits.
![Example Lens line chart reference lines](https://www.elastic.co/docs/explore-analyze/images/kibana-line-reference-lines.png)
1. In the chart settings, add a static value reference line to mark your target or threshold visually.
2. Use the **Text decoration** setting to provide a name, for example, `Target` or `SLO`, choose a color, and optionally a band.


## Line chart settings

Customize your line chart to display exactly the information you need, formatted the way you want.

### Horizontal axis settings

<definitions>
  <definition term="Data">
    - **Functions**:
      - **Date histogram**: Group data points into time-based buckets (for example, hourly, daily, weekly).
    - **Intervals**: Determine the size of the time buckets in your date histogram. You can define the intervals granularity or specify custom ranges.
    - **Filters**: Allow you to segment your data based on specific conditions, creating separate lines for each filter.
    - **Top values**: Create separate lines for the most common values in a field.
  </definition>
  <definition term="Appearance">
    **Name**: By default, the chart uses the function or formula as title. It's a best practice to customize this with a meaningful title.
  </definition>
</definitions>


### Vertical axis settings

<definitions>
  <definition term="Data">
    To represent the metrics or values you want to visualize, you can use quick functions like `Average`, `Count`, `Percentile`, `Counter rate`, or create custom calculations with formulas. Refer to [Lens > Use formulas to perform math](/docs/explore-analyze/visualize/lens#lens-formulas) for examples, or to the `documentation` **Formula reference** available from Lens.
    <dropdown title="Advanced settings">
      Depending on the data you defined, several options allow you to apply additional filtering to the data taken into account to compute the final value to show.Based on the type of visualization you're creating, only some of the following options can be available:
      - **Normalize by unit**: Normalize the metric values to show per unit of time.
      - **Filter by**: Specify a query.
      - **Reduced time range**: Reduce the time range specified on the dashboard's time filter by the specified duration.
      - **Time shift**: Shift the time range by the specified duration. This is useful if the value should use a different time range than the one selected on the dashboard.
      - **Hide zero values**: Don't show values equal to zero. This option is on by default.
    </dropdown>
  </definition>
</definitions>

**Appearance**
- **Name**: Customize the legend label with a descriptive name.
- **Value format**: Control how numeric values are displayed on the vertical axis of your visualization.
- **Series color**: Select a palette or specific color per series.
- **Axis side**: Control where axis labels and tick marks appear.


### Breakdown settings

Breakdown functions segment your data into multiple lines on the same chart, with each line representing a different value of a categorical field. You can specify the following options:
<definitions>
  <definition term="Data">
    - **Functions**:
      - **Date histogram**: Group data points into time-based buckets (for example, hourly, daily, weekly).
    - **Intervals**: Determine the size of the time buckets in your date histogram. You can define the intervals granularity or specify custom ranges.
    - **Filters**: Allow you to segment your data based on specific conditions, creating separate lines for each filter.
    - **Top values**: Create separate lines for the most common values in a field.
  </definition>
</definitions>

Depending on the function and type of field that you select, you can specify more advanced settings.
<definitions>
  <definition term="Appearance">
    Allow you to customize how your breakdown data is displayed in line charts, including:
    - **Name**: It's a best practice to customize this with a meaningful title.
    - **Value format**: Control how numeric values are displayed in your visualization.
    - **Color mapping**: Determine how colors are assigned to your breakdown series.
  </definition>
</definitions>


### General layout

When creating or editing a visualization, you can adjust the following settings.
<dropdown title="Style">
  Adjust the visual appearance of your line chart to control how the data series are labeled and displayed alongside your chart. Click `brush` to open the **Style** panel.
  <definitions>
    <definition term="Appearance">
      Allow you to customize to overall chart appearance:
    </definition>
  </definitions>

  - **Point visibility**: Use this option to show or hide data points. Set to **Auto** by default: Points are visible unless the distance between them is too short.
    - **Line interpolation**: Choose how to interpolate the line between data points from the available options: **Straight** (default), **Smooth**, and **Step**.
  - **Missing values**: Choose between **Hide**, **Zero**, **Linear**, **Last**, and **Next**. This option controls how gaps in data appear on the chart. By default, gaps are hidden. Missing values include empty buckets and metrics: Buckets without documents or metrics that returned `null` due to their operation and data content.
    <note>
    You can only use this option when the **Include empty rows** option of the chart is enabled or when a metric produces a null bucket. For example, if a moving average finds empty buckets.
    </note>
    - **Hide**: Don't show gaps in data.
  - **Zero**: Fill gaps by connecting starting and ending data points to zero.
  - **Linear**: Fill gaps by connecting related starting and ending data points together with a direct line.
  - **Last**: Fill gaps between data points with a horizontal or vertical line that uses the last ending point value, when available, to determine its position.
  - **Next**: Fill gaps between data points with a horizontal or vertical line that uses the next starting point value, when available, to determine its position.
  - <definitions>
    <definition term="End values">
    If you've chosen to show missing values, you can also decide to extend data series to the edge of the chart. By default, end values are hidden.
    </definition>
    </definitions>
    - **Hide**: Don't extend series to the edge of the chart.
    - **Zero**: Extend series as zero to the edge of the chart.
  - **Nearest**: Extend series with their first or last value to the edge of the chart.
  - <definitions>
    <definition term="Show as dotted line">
    If you've chosen to show missing values, you can turn on this option to show gaps as a dotted line.
    </definition>
    </definitions>

  <definitions>
    <definition term="Left axis">
      Allow you to customize the Y-axis appearance.
    </definition>
  </definitions>

  - **Axis Title**. Show, hide or add a custom title.
    - **Gridlines**. Show or hide gridlines.
  - **Tick labels**. Show or hide tick labels.
  - **Orientation**. Choose the tick labels orientation.
  - **Axis scale**. Choose an axis scale type. Options include: Linear (default), Logarithmic, and Square root.
  - **Bounds**. Use Bounds to set the minimum and maximum values for the Y-axis. Options include: Full, Data, and Custom
  - **Round to nice value**. Axis labels can be rounded to more readable numbers.

  <definitions>
    <definition term="Bottom axis">
      Allow you to customize the bottom axis appearance:
    </definition>
  </definitions>

  - **Axis Title**. Show, hide or add a custom title.
    - **Gridlines**. Show/hide gridlines.
  - **Tick labels**. Show/hide tick labels.
  - **Show partial data markers**: indicate data points where Data collection is incomplete (the time bucket is still open and actively collecting events), or data may change (the values represented might increase as more data arrives).
  - **Show current time marker**: Add a vertical line on your chart that represents the current time.
</dropdown>

<dropdown title="Legend">
  You can customize the way the legend is displayed and the data it shows. Click ![Legend icon](https://www.elastic.co/docs/explore-analyze/images/kibana-legend-icon.svg) to open the **Legend** panel.With the **Visibility**, **Position**, and **Width** options, you can adjust the way the legend appears in or next to the visualization.
  <definitions>
    <definition term="Statistics">
      To make your legends as informative as possible, you can show some additional statistics. All statistics are computed based on the selected time range and the aggregated data points shown in the chart, rather than the original data coming from Elasticsearch. For example, if the metric plotted in the chart is Median(system.memory) and the time range is last 24 hours, when you show the Max statistic in the Legend, the value that shows corresponds to the Max[Median(system.memory)] for the last 24 hours.
    </definition>
  </definitions>

  - **Average**: Average value considering all data points in the chart.
    - **Median**: Median value considering all data points in the chart.
  - **Minimum**: Minimum value considering all data points in the chart.
  - **Maximum**: Maximum value considering all data points in the chart.
  - **Range**: Difference between min and max values.
  - **Last value**: Last value considering all data points in the chart.
  - **Last non-null value**: Last non-null value.

  <definitions>
    <definition term="Label truncation">
      Keep your legend minimal in case of long labels that span over multiple lines. You can adjust the line limit.
    </definition>
  </definitions>
</dropdown>


## Line chart examples

<definitions>
  <definition term="Average RAM per host">
    Monitoring the average of RAM over time for the first four hosts:
  </definition>
</definitions>

1. Drag `@timestamp` to the **Horizontal axis** and set the following settings:
   - **Functions**: `Date histogram`
- **Minimum interval**: `Hour`
2. Drag `machine.ram` to the **Vertical axis** and set the following settings:
   - **Functions**: : `Moving average`
- **Value format**: `Bytes`
3. In the **Breakdwon** panel, set the following settings:
   - **Functions**: `Top values`
- **Fields**: `host.keyword`
- **Number of values**: `4`
4. Save your chart.
   ![Average RAM per host](https://www.elastic.co/docs/explore-analyze/images/kibana-lens-average-ram-host.png)

<definitions>
  <definition term="Unique IPs over time">
    Visualizing unique IP sessions throughout the day:
  </definition>
</definitions>

1. Drag `@timestamp` to the **Horizontal axis** and set the following settings:
   - **Functions**: `Date histogram`
- **Minimum interval**: `Hour`
2. Drag `host.keyword` to the **Vertical axis** and set the following settings:
   - **Functions**: : `Unique count`
- **Value format**: `Bytes (1024)`
- **Decimals**: `0`
3. Save your chart.
   ![Unique IPs throughout the day](https://www.elastic.co/docs/explore-analyze/images/kibana-lens-unique-ip-throughout-day.png)

---