﻿---
title: Build area charts with Kibana
description: Instructions and best practices for building area charts with Kibana Lens in Elastic.
url: https://www.elastic.co/docs/explore-analyze/visualize/charts/area-charts
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Build area charts with Kibana
Area charts are line charts with the area below the line filled in with a certain color or texture. Area charts work with numeric metrics over the horizontal axis (typically time) and are ideal to display quantitative values over an interval or time period, to show trends for time series like traffic, CPU, revenue, or error rates.
You can create area charts in Kibana using [**Lens**](https://www.elastic.co/docs/explore-analyze/visualize/lens).
![Example Lens area chart](https://www.elastic.co/docs/explore-analyze/images/kibana-area-chart.png)

## Build an area chart

To build an area chart:
<stepper>
  <step title="Access Lens">
    **Lens** is Kibana's main visualization editor. You can access it:
    - From a dashboard: On the **Dashboards** page, open or create the dashboard where you want to add an area chart, then add a new visualization.
    - From the **Visualize library** page by creating a new visualization.
  </step>

  <step title="Set the visualization to Area">
    New visualizations often start as **Bar** charts.Using the **Visualization type** dropdown, select **Area**.
  </step>

  <step title="Define the data to show">
    1. Select the data view that contains your data.
    2. Drag a [time field](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/date) to the **Horizontal axis** and a numeric field to the **Vertical axis**. Kibana automatically selects an appropriate aggregation function compatible with the selected field.
    Optionally:
    - Add more numeric fields to create additional series, or drag a categorical field to the **Breakdown** settings to segment your data by a categorical field, and create multiple areas within the same chart.
    - You can click the **Add layer** icon `plus_in_square` to integrate additional visualizations, [annotations](/docs/explore-analyze/visualize/lens#add-annotations), or a [reference line](/docs/explore-analyze/visualize/lens#add-reference-lines).
  </step>

  <step title="Customize the chart to follow best practices">
    Tweak the appearance of the chart to your needs. Consider the following best practices:
    <definitions>
      <definition term="Choose the right stack mode">
        Use **Stacked** to show contribution to a whole, **Percentage** for normalized representation of values, or **Unstacked** when absolute trends matter more than composition. For a practical use case, check how to [show composition with stacked and 100% stacked areas](#area-stacking).
      </definition>
      <definition term="Handle gaps and noise">
        For sparse data, configure **Missing values** and **Line interpolation** to avoid misleading gaps or sharp edges. Check the [Visualization appearance options](/docs/explore-analyze/visualize/lens#customize-visualization-appearance).
      </definition>
      <definition term="Use color purposefully">
        Apply colors to highlight important data or patterns. Avoid using too many colors that might distract from the data. You can also assign [consistent colors to key categories](/docs/explore-analyze/visualize/lens#assign-colors-to-terms).
      </definition>
      <definition term="Label clearly">
        Provide a descriptive title and axis labels that clearly communicate what the chart shows. For example, mention the metric being visualized ("Average Response Time") and reference the time period when relevant ("Dec 8-16, 2025").
      </definition>
    </definitions>
    Refer to [Area chart settings](#area-chart-settings) to find all configuration options for your area chart.
  </step>

  <step title="Save the chart">
    - If you accessed Lens from a dashboard, select **Save and return** to save the visualization and add it to that dashboard, or select **Save to library** to add the visualization to the Visualize library and reuse it later.
    - If you accessed Lens from the Visualize library, select **Save**. A menu opens and offers you to add the visualization to a dashboard and to the Visualize library.
  </step>
</stepper>


## Advanced area scenarios


### Show composition with stacked and 100% stacked areas

Use stacking to show how categories contribute to a total over time.
1. Create an area chart with a time-based **Horizontal axis**.
2. Break down the series by a categorical field, for example, `agent.keyword`, `response.keyword`.
   You can set the area chart stack mode to:
   - **Stacked** — Show cumulative totals and category contributions.
  ![Example Lens area chart stacked mode](https://www.elastic.co/docs/explore-analyze/images/kibana-area-stacked.png)
- **Percentage (100%)** — Normalizes each timestamp to 100% to emphasize shares rather than magnitudes.
  ![Example Lens area chart percentage mode](https://www.elastic.co/docs/explore-analyze/images/kibana-area-percentage.png)
3. Optionally, in the **Breakdown** settings, you can set **Rank by** to specify the dimension the top values are ranked by.


### Compare current versus previous period with time shift

In Area charts, you can enable time shift to compare different periods and identify deltas.
![Example Lens area chart compare periods](https://www.elastic.co/docs/explore-analyze/images/kibana-area-compare-periods.png)
1. Create an area chart with a time-based **Horizontal axis** and your main metric on **Vertical axis**, for example: `bytes`.
2. Duplicate the layer:
   - <applies-to>Elastic Cloud Serverless: Generally available</applies-to> <applies-to>Elastic Stack: Generally available since 9.3</applies-to> Select `copy` **Duplicate layer** from the visualization editor.
- <applies-to>Elastic Stack: Generally available from 9.0 to 9.2</applies-to> Open the `boxes_vertical` contextual menu of the visualization editor and select `copy` **Duplicate layer**.
3. From the duplicated layer settings, select the field defined as vertical axis to open its details. Expand its **Advanced** options and set **Time shift** to `1w` or to the time value of your choice.
   Check [Compare differences over time](/docs/explore-analyze/visualize/lens#compare-data-with-time-offsets) for more details.
4. Optionally, customize the appearance of the layer to adjust how it looks on the chart. When you duplicate a layer, Kibana automatically assigns a different **Series color** to the new layer. You can for example change this color, or adjust the layer's name and axis position. This name is used for the chart's legend.

<tip>
  You can also compute the relative change using a formula, for example:

  `(average(bytes) - average(bytes, shift='1w')) / average(bytes, shift='1w')`
</tip>


## Area chart settings

Customize your area chart to match the information you need and how you want it displayed.

### Horizontal axis settings

<definitions>
  <definition term="Data">
    - **Functions**:
      - **Date histogram**: Group data points into time-based buckets (for example, hourly, daily, weekly).
    - **Intervals**: Determine the size of the time buckets in your date histogram. You can define the intervals granularity or specify custom ranges.
    - **Filters**: Allow you to segment your data based on specific conditions, creating separate lines for each filter.
    - **Top values**: Create separate lines for the most common values in a field.
  </definition>
  <definition term="Appearance">
    **Name**: By default, the chart uses the function or formula as title. It's a best practice to customize this with a meaningful title.
  </definition>
</definitions>


### Vertical axis settings

<definitions>
  <definition term="Data">
    To represent the metrics or values you want to visualize, you can use quick functions like Average, Count, Percentile, Counter rate, or create custom calculations with formulas. Refer to [Lens > Use formulas to perform math](/docs/explore-analyze/visualize/lens#lens-formulas) for examples.
    <dropdown title="Advanced settings">
      Depending on the data you defined, you can use the following options to apply additional filtering:
      - **Filter by**: Specify a query.
      - **Time shift**: Compare current data with historical data by shifting the time frame of your metrics.
    </dropdown>
  </definition>
  <definition term="Appearance">
    Configure series-level options, including:
    - **Name**: Customize the series label.
    - **Value format**: Control how numeric values are displayed on your vertical axis and in tooltips.
    - **Series color**: Determine the color of your data series in the visualization.
    - **Axis side**: Determine which side of the chart the vertical axis appears on.
  </definition>
</definitions>


### Breakdown settings

You can split your data by a categorical field to create multiple stacked or overlapping areas. You can specify the following options:
<definitions>
  <definition term="Data">
    - **Functions**:
      - **Date histogram**: Group data points into time-based buckets (for example, hourly, daily, weekly).
    - **Intervals**: Define the intervals granularity or specify custom ranges.
    - **Filters**: Create separate colored areas based on filter conditions.
    - **Top values**: Limit to show only the top N values (for example, top 5, top 10).
    - **Fields**: Depending on the function and type of field that you select, you can specify more advanced settings.
    - **Number of values**: The number of tiles to show. If more values are available for the selected breakdown field, an additional tile named **Other** shows if the **Group remaining values as "Other"** advanced option is on.
    - **Rank by**: The dimension by which top values are ranked.
    - **Rank direction**: The direction to use for the ranking.
    - **Collapse by**: Aggregate values of the various tiles into a single number. Possible aggregation options are `None` (default), `Sum`, `Average`, `Min`, and `Max`.
    <dropdown title="Advanced settings">
      Several advanced options allow you to refine the behavior of the breakdown:
      - **Include documents without the selected field**: Off by default.
      - **Group remaining values as "Other"**: On by default.
      - **Enable accuracy mode**: This option improves results for high-cardinality data, but increases the load on the Elasticsearch cluster.
      - **Include values**: Values from the breakdown dimension to always show a tile for.
      - **Exclude values**: Values from the breakdown dimension to always exclude from the displayed tiles.
    </dropdown>
  </definition>
  <definition term="Appearance">
    Allow you to customize how your breakdown data is displayed in line charts, including:
    - **Name**: It's a best practice to customize this with a meaningful title.
    - **Color mapping**: Determine how colors are assigned to your breakdown series.
  </definition>
</definitions>


### General layout

When creating or editing a visualization, you can adjust the following settings.
<dropdown title="Style">
  Adjust the visual appearance of your area chart to control how the data series are labeled and displayed alongside your chart. Click `brush` to open the **Style** panel.
  <definitions>
    <definition term="Appearance">
      Allow you to customize the overall chart appearance:
    </definition>
  </definitions>

  - **Area fill opacity**: Control how transparent or opaque the colored area beneath the data line appears. The opacity value ranges from 0 to 1.
  - **Point visibility**: Show or hide data points. Set to **Auto** by default: Points are visible unless the distance between them is too short.
  - **Line interpolation**: Choose how to interpolate the line between data points from the available options: **Straight** (default), **Smooth**, and **Step**.
  - **Missing values**: Choose between **Hide**, **Zero**, **Linear**, **Last**, and **Next**. This option controls how gaps in data appear on the chart. By default, gaps are hidden. Missing values include empty buckets and metrics: Buckets without documents or metrics that returned `null` due to their operation and data content.
    <note>
    You can only use this option when the **Include empty rows** option of the chart is enabled or when a metric produces a null bucket. For example, if a moving average finds empty buckets.
    </note>
    - **Hide**: Don't show gaps in data.
  - **Zero**: Fill gaps by connecting starting and ending data points to zero.
  - **Linear**: Fill gaps by connecting related starting and ending data points together with a direct line.
  - **Last**: Fill gaps between data points with a horizontal or vertical line that uses the last ending point value, when available, to determine its position.
  - **Next**: Fill gaps between data points with a horizontal or vertical line that uses the next starting point value, when available, to determine its position.

  - **End values**: If you've chosen to show missing values, you can also decide to extend data series to the edge of the chart. By default, end values are hidden.
    - **Hide**: Don't extend series to the edge of the chart.
  - **Zero**: Extend series as zero to the edge of the chart.
  - **Nearest**: Extend series with their first or last value to the edge of the chart.
  - **Show as dotted line**: If you've chosen to show missing values, you can turn on this option to show gaps as a dotted line.

  <definitions>
    <definition term="Left axis">
      Allow you to customize the Y-axis appearance.
    </definition>
  </definitions>

  - **Axis Title**. Show, hide or add a custom title.
  - **Gridlines**. Show or hide gridlines.
  - **Tick labels**. Show or hide tick labels.
  - **Orientation**. Choose the tick labels orientation.
  - **Axis scale**. Choose an axis scale type. Options include: Linear (default), Logarithmic, and Square root.
  - **Bounds**. Use Bounds to set the minimum and maximum values for the Y-axis. Options include: Full, Data, and Custom
  - **Round to nice value**. Axis labels can be rounded to more readable numbers.

  <definitions>
    <definition term="Bottom axis">
      Allow you to customize the bottom axis appearance:
    </definition>
  </definitions>

  - **Axis Title**. Show, hide or add a custom title.
  - **Gridlines**. Show/hide gridlines.
  - **Tick labels**. Show/hide tick labels.
  - **Show partial data markers**: indicate data points where Data collection is incomplete (the time bucket is still open and actively collecting events), or data may change (the values represented might increase as more data arrives).
  - **Show current time marker**: Add a vertical line on your chart that represents the current time.
</dropdown>

<dropdown title="Legend">
  You can customize the way the legend is displayed and the data it shows. Click ![Legend icon](https://www.elastic.co/docs/explore-analyze/images/kibana-legend-icon.svg) to open the **Legend** panel.With the **Visibility**, **Position**, and **Width** options, you can adjust the way the legend appears in or next to the visualization.
  <definitions>
    <definition term="Statistics">
      To make your legends as informative as possible, you can show some additional statistics. All statistics are computed based on the selected time range and the aggregated data points shown in the chart, rather than the original data coming from Elasticsearch. For example, if the metric plotted in the chart is Median(system.memory) and the time range is last 24 hours, when you show the Max statistic in the Legend, the value that shows corresponds to the Max[Median(system.memory)] for the last 24 hours.
    </definition>
  </definitions>

  - **Average**: Average value considering all data points in the chart.
    - **Median**: Median value considering all data points in the chart.
  - **Minimum**: Minimum value considering all data points in the chart.
  - **Maximum**: Maximum value considering all data points in the chart.
  - **Range**: Difference between min and max values.
  - **Last value**: Last value considering all data points in the chart.
  - **Last non-null value**: Last non-null value.

  <definitions>
    <definition term="Label truncation">
      Keep your legend minimal in case of long labels that span over multiple lines. You can adjust the line limit.
    </definition>
  </definitions>
</dropdown>


## Area chart examples

<definitions>
  <definition term="Traffic by geographic region">
    Visualizing which geographic regions generate the most traffic:
    - **Horizontal axis**: `@timestamp` (Date histogram)
    - **Vertical axis**: `records`
    - **Breakdown**: `geo.dest`
  </definition>
</definitions>

![Example Lens area chart geographical regions](https://www.elastic.co/docs/explore-analyze/images/kibana-area-geo-regions.png)
<definitions>
  <definition term="Response code over time with annotations">
    Visualizing HTTP response codes over time, highlighting the proportion of success, client error, and server error responses, with annotations for key events:
  </definition>
</definitions>

- **Horizontal axis**: `@timestamp` (Date histogram)
- **Vertical axis**: `Count of records`
  - **Breakdown**:
  - **Success/Redirection**`response.keyword >= 200 and response.keyword < 400`
- **Client Error**`response.keyword >= 400 and response.keyword < 500`
- **Server Error**`response.keyword >= 500`
- **Stacking**: `Percentage` to show the distribution relative to the total count at each point in time.
  - **Annotation Query**: `tags:error AND tags:security`
  ![Example Lens area chart response code annotations](https://www.elastic.co/docs/explore-analyze/images/kibana-response-code-annotations.png)