﻿---
title: TinyMath functions
description: TinyMath provides a set of functions that can be used with the Canvas expression language to perform complex math calculations. Read on for detailed information...
url: https://www.elastic.co/docs/explore-analyze/visualize/canvas/canvas-tinymath-functions
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# TinyMath functions
TinyMath provides a set of functions that can be used with the Canvas expression language to perform complex math calculations. Read on for detailed information about the functions available in TinyMath, including what parameters each function accepts, the return value of that function, and examples of how each function behaves.
Most of the functions accept arrays and apply JavaScript Math methods to each element of that array. For the functions that accept multiple arrays as parameters, the function generally does the calculation index by index.
Any function can be wrapped by another function as long as the return type of the inner function matches the acceptable parameter type of the outer function.

## abs( a )

Calculates the absolute value of a number. For arrays, the function will be applied index-wise to each element.

| Param | Type                   | Description                     |
|-------|------------------------|---------------------------------|
| a     | number  Array.<number> | a number or an array of numbers |

**Returns**: `number`  `Array.<number>`. The absolute value of `a`. Returns an array with the absolute values of each element if `a` is an array.
**Example**
```js
abs(-1)
abs(2)
abs([-1 , -2, 3, -4])
```


## add( …args )

Calculates the sum of one or more numbers/arrays passed into the function. If at least one array of numbers is passed into the function, the function will calculate the sum by index.

| Param | Type                   | Description                              |
|-------|------------------------|------------------------------------------|
| …args | number  Array.<number> | one or more numbers or arrays of numbers |

**Returns**: `number`  `Array.<number>`. The sum of all numbers in `args` if `args` contains only numbers. Returns an array of sums of the elements at each index, including all scalar numbers in `args` in the calculation at each index if `args` contains at least one array.
**Throws**: `'Array length mismatch'` if `args` contains arrays of different lengths
**Example**
```js
add(1, 2, 3)
add([10, 20, 30, 40], 10, 20, 30)
add([1, 2], 3, [4, 5], 6)
```


## cbrt( a )

Calculates the cube root of a number. For arrays, the function will be applied index-wise to each element.

| Param | Type                   | Description                     |
|-------|------------------------|---------------------------------|
| a     | number  Array.<number> | a number or an array of numbers |

**Returns**: `number`  `Array.<number>`. The cube root of `a`. Returns an array with the cube roots of each element if `a` is an array.
**Example**
```js
cbrt(-27)
cbrt(94)
cbrt([27, 64, 125])
```


## ceil( a )

Calculates the ceiling of a number, i.e., rounds a number towards positive infinity. For arrays, the function will be applied index-wise to each element.

| Param | Type                   | Description                     |
|-------|------------------------|---------------------------------|
| a     | number  Array.<number> | a number or an array of numbers |

**Returns**: `number`  `Array.<number>`. The ceiling of `a`. Returns an array with the ceilings of each element if `a` is an array.
**Example**
```js
ceil(1.2)
ceil(-1.8)
ceil([1.1, 2.2, 3.3])
```


## clamp( …a, min, max )

Restricts value to a given range and returns closed available value. If only `min` is provided, values are restricted to only a lower bound.

| Param | Type                   | Description                                             |
|-------|------------------------|---------------------------------------------------------|
| …a    | number  Array.<number> | one or more numbers or arrays of numbers                |
| min   | number  Array.<number> | (optional) The minimum value this function will return. |
| max   | number  Array.<number> | (optional) The maximum value this function will return. |

**Returns**: `number`  `Array.<number>`. The closest value between `min` (inclusive) and `max` (inclusive). Returns an array with values greater than or equal to `min` and less than or equal to `max` (if provided) at each index.
**Throws**:
- `'Array length mismatch'` if a `min` and/or `max` are arrays of different lengths
- `'Min must be less than max'` if `max` is less than `min`

**Example**
```js
clamp(1, 2, 3)
clamp([10, 20, 30, 40], 15, 25)
clamp(10, [15, 2, 4, 20], 25)
clamp(35, 10, [20, 30, 40, 50])
clamp([1, 9], 3, [4, 5])
```


## count( a )

Returns the length of an array. Alias for size.

| Param | Type        | Description         |
|-------|-------------|---------------------|
| a     | Array.<any> | array of any values |

**Returns**: `number`. The length of the array.
**Throws**: `'Must pass an array'` if `a` is not an array.
**Example**
```js
count([])
count([-1, -2, -3, -4])
count(100)
```


## cube( a )

Calculates the cube of a number. For arrays, the function will be applied index-wise to each element.

| Param | Type                   | Description                     |
|-------|------------------------|---------------------------------|
| a     | number  Array.<number> | a number or an array of numbers |

**Returns**: `number`  `Array.<number>`. The cube of `a`. Returns an array with the cubes of each element if `a` is an array.
**Example**
```js
cube(-3)
cube([3, 4, 5])
```


## divide( a, b )

Divides two numbers. If at least one array of numbers is passed into the function, the function will be applied index-wise to each element.

| Param | Type                   | Description                                      |
|-------|------------------------|--------------------------------------------------|
| a     | number  Array.<number> | dividend, a number or an array of numbers        |
| b     | number  Array.<number> | divisor, a number or an array of numbers, b != 0 |

**Returns**: `number`  `Array.<number>`. Returns the quotient of `a` and `b` if both are numbers. Returns an array with the quotients applied index-wise to each element if `a` or `b` is an array.
**Throws**:
- `'Array length mismatch'` if `a` and `b` are arrays with different lengths
- `'Cannot divide by 0'` if `b` equals 0 or contains 0

**Example**
```js
divide(6, 3)
divide([10, 20, 30, 40], 10)
divide(10, [1, 2, 5, 10])
divide([14, 42, 65, 108], [2, 7, 5, 12])
```


## exp( a )

Calculates *e^x* where *e* is Euler’s number. For arrays, the function will be applied index-wise to each element.

| Param | Type                   | Description                     |
|-------|------------------------|---------------------------------|
| a     | number  Array.<number> | a number or an array of numbers |

**Returns**: `number`  `Array.<number>`. Returns an array with the values of `e^x` evaluated where `x` is each element of `a` if `a` is an array.
**Example**
```js
exp(2)
exp([1, 2, 3])
```


## first( a )

Returns the first element of an array. If anything other than an array is passed in, the input is returned.

| Param | Type        | Description         |
|-------|-------------|---------------------|
| a     | Array.<any> | array of any values |

**Returns**: `*`. The first element of `a`. Returns `a` if `a` is not an array.
**Example**
```js
first(2)
first([1, 2, 3])
```


## fix( a )

Calculates the fix of a number, i.e., rounds a number towards 0. For arrays, the function will be applied index-wise to each element.

| Param | Type                   | Description                     |
|-------|------------------------|---------------------------------|
| a     | number  Array.<number> | a number or an array of numbers |

**Returns**: `number`  `Array.<number>`. The fix of `a`. Returns an array with the fixes for each element if `a` is an array.
**Example**
```js
fix(1.2)
fix(-1.8)
fix([1.8, 2.9, -3.7, -4.6])
```


## floor( a )

Calculates the floor of a number, i.e., rounds a number towards negative infinity. For arrays, the function will be applied index-wise to each element.

| Param | Type                   | Description                     |
|-------|------------------------|---------------------------------|
| a     | number  Array.<number> | a number or an array of numbers |

**Returns**: `number`  `Array.<number>`. The floor of `a`. Returns an array with the floor of each element if `a` is an array.
**Example**
```js
floor(1.8)
floor(-1.2)
floor([1.7, 2.8, 3.9])
```


## last( a )

Returns the last element of an array. If anything other than an array is passed in, the input is returned.

| Param | Type        | Description         |
|-------|-------------|---------------------|
| a     | Array.<any> | array of any values |

**Returns**: `*`. The last element of `a`. Returns `a` if `a` is not an array.
**Example**
```js
last(2)
last([1, 2, 3])
```


## log( a, b )

Calculates the logarithm of a number. For arrays, the function will be applied index-wise to each element.

| Param | Type                   | Description                                                                                                           |
|-------|------------------------|-----------------------------------------------------------------------------------------------------------------------|
| a     | number  Array.<number> | a number or an array of numbers, `a` must be greater than 0                                                           |
| b     | Object                 | (optional) base for the logarithm. If not provided a value, the default base is e, and the natural log is calculated. |

**Returns**: `number`  `Array.<number>`.  The logarithm of `a`. Returns an array with the the logarithms of each element if `a` is an array.
**Throws**:
- `'Base out of range'` if `b` ⇐ 0
- `'Must be greater than 0'` if `a` > 0

**Example**
```js
log(1)
log(64, 8)
log(42, 5)
log([2, 4, 8, 16, 32], 2)
```


## log10( a )

Calculates the logarithm base 10 of a number. For arrays, the function will be applied index-wise to each element.

| Param | Type                   | Description                                                 |
|-------|------------------------|-------------------------------------------------------------|
| a     | number  Array.<number> | a number or an array of numbers, `a` must be greater than 0 |

**Returns**: `number`  `Array.<number>`. The logarithm of `a`. Returns an array with the the logarithms base 10 of each element if `a` is an array.
**Throws**: `'Must be greater than 0'` if `a` < 0
**Example**
```js
log(10)
log(100)
log(80)
log([10, 100, 1000, 10000, 100000])
```


## max( …args )

Finds the maximum value of one of more numbers/arrays of numbers passed into the function. If at least one array of numbers is passed into the function, the function will find the maximum by index.

| Param | Type                   | Description                              |
|-------|------------------------|------------------------------------------|
| …args | number  Array.<number> | one or more numbers or arrays of numbers |

**Returns**: `number`  `Array.<number>`. The maximum value of all numbers if `args` contains only numbers. Returns an array with the the maximum values at each index, including all scalar numbers in `args` in the calculation at each index if `args` contains at least one array.
**Throws**: `'Array length mismatch'` if `args` contains arrays of different lengths
**Example**
```js
max(1, 2, 3)
max([10, 20, 30, 40], 15)
max([1, 9], 4, [3, 5])
```


## mean( …args )

Finds the mean value of one of more numbers/arrays of numbers passed into the function. If at least one array of numbers is passed into the function, the function will find the mean by index.

| Param | Type                   | Description                              |
|-------|------------------------|------------------------------------------|
| …args | number  Array.<number> | one or more numbers or arrays of numbers |

**Returns**: `number`  `Array.<number>`. The mean value of all numbers if `args` contains only numbers. Returns an array with the the mean values of each index, including all scalar numbers in `args` in the calculation at each index if `args` contains at least one array.
**Example**
```js
mean(1, 2, 3)
mean([10, 20, 30, 40], 20)
mean([1, 9], 5, [3, 4])
```


## median( …args )

Finds the median value(s) of one of more numbers/arrays of numbers passed into the function. If at least one array of numbers is passed into the function, the function will find the median by index.

| Param | Type                   | Description                              |
|-------|------------------------|------------------------------------------|
| …args | number  Array.<number> | one or more numbers or arrays of numbers |

**Returns**: `number`  `Array.<number>`. The median value of all numbers if `args` contains only numbers. Returns an array with the the median values of each index, including all scalar numbers in `args` in the calculation at each index if `args` contains at least one array.
**Example**
```js
median(1, 1, 2, 3)
median(1, 1, 2, 2, 3)
median([10, 20, 30, 40], 10, 20, 30)
median([1, 9], 2, 4, [3, 5])
```


## min( …args )

Finds the minimum value of one of more numbers/arrays of numbers passed into the function. If at least one array of numbers is passed into the function, the function will find the minimum by index.

| Param | Type                   | Description                              |
|-------|------------------------|------------------------------------------|
| …args | number  Array.<number> | one or more numbers or arrays of numbers |

**Returns**: `number`  `Array.<number>`. The minimum value of all numbers if `args` contains only numbers. Returns an array with the the minimum values of each index, including all scalar numbers in `args` in the calculation at each index if `a` is an array.
**Throws**: `'Array length mismatch'` if `args` contains arrays of different lengths.
**Example**
```js
min(1, 2, 3)
min([10, 20, 30, 40], 25)
min([1, 9], 4, [3, 5])
```


## mod( a, b )

Remainder after dividing two numbers. If at least one array of numbers is passed into the function, the function will be applied index-wise to each element.

| Param | Type                   | Description                                      |
|-------|------------------------|--------------------------------------------------|
| a     | number  Array.<number> | dividend, a number or an array of numbers        |
| b     | number  Array.<number> | divisor, a number or an array of numbers, b != 0 |

**Returns**: `number`  `Array.<number>`. The remainder of `a` divided by `b` if both are numbers. Returns an array with the the remainders applied index-wise to each element if `a` or `b` is an array.
**Throws**:
- `'Array length mismatch'` if `a` and `b` are arrays with different lengths
- `'Cannot divide by 0'` if `b` equals 0 or contains 0

**Example**
```js
mod(10, 7)
mod([11, 22, 33, 44], 10)
mod(100, [3, 7, 11, 23])
mod([14, 42, 65, 108], [5, 4, 14, 2])
```


## mode( …args )

Finds the mode value(s) of one of more numbers/arrays of numbers passed into the function. If at least one array of numbers is passed into the function, the function will find the mode by index.

| Param | Type                   | Description                              |
|-------|------------------------|------------------------------------------|
| …args | number  Array.<number> | one or more numbers or arrays of numbers |

**Returns**: `number`  `Array.<Array.<number>>`. An array of mode value(s) of all numbers if `args` contains only numbers. Returns an array of arrays with mode value(s) of each index, including all scalar numbers in `args` in the calculation at each index if `args` contains at least one array.
**Example**
```js
mode(1, 1, 2, 3)
mode(1, 1, 2, 2, 3)
mode([10, 20, 30, 40], 10, 20, 30)
mode([1, 9], 1, 4, [3, 5])
```


## multiply( a, b )

Multiplies two numbers. If at least one array of numbers is passed into the function, the function will be applied index-wise to each element.

| Param | Type                   | Description                     |
|-------|------------------------|---------------------------------|
| a     | number  Array.<number> | a number or an array of numbers |
| b     | number  Array.<number> | a number or an array of numbers |

**Returns**: `number`  `Array.<number>`. The product of `a` and `b` if both are numbers. Returns an array with the the products applied index-wise to each element if `a` or `b` is an array.
**Throws**: `'Array length mismatch'` if `a` and `b` are arrays with different lengths
**Example**
```js
multiply(6, 3)
multiply([10, 20, 30, 40], 10)
multiply(10, [1, 2, 5, 10])
multiply([1, 2, 3, 4], [2, 7, 5, 12])
```


## pow( a, b )

Calculates the cube root of a number. For arrays, the function will be applied index-wise to each element.

| Param | Type                   | Description                     |
|-------|------------------------|---------------------------------|
| a     | number  Array.<number> | a number or an array of numbers |
| b     | number                 | the power that `a` is raised to |

**Returns**: `number`  `Array.<number>`. `a` raised to the power of `b`. Returns an array with the each element raised to the power of `b` if `a` is an array.
**Throws**: `'Missing exponent'` if `b` is not provided
**Example**
```js
pow(2,3)
pow([1, 2, 3], 4)
```


## random( a, b )

Generates a random number within the given range where the lower bound is inclusive and the upper bound is exclusive. If no numbers are passed in, it will return a number between 0 and 1. If only one number is passed in, it will return a number between 0 and the number passed in.

| Param | Type   | Description                                              |
|-------|--------|----------------------------------------------------------|
| a     | number | (optional) must be greater than 0 if `b` is not provided |
| b     | number | (optional) must be greater than `a`                      |

**Returns**: `number`. A random number between 0 and 1 if no numbers are passed in. Returns a random number between 0 and `a` if only one number is passed in. Returns a random number between `a` and `b` if two numbers are passed in.
**Throws**: `'Min must be greater than max'` if `a` < 0 when only `a` is passed in or if `a` > `b` when both `a` and `b` are passed in
**Example**
```js
random()
random(10)
random(-10,10)
```


## range( …args )

Finds the range of one of more numbers/arrays of numbers passed into the function. If at least one array of numbers is passed into the function, the function will find the range by index.

| Param | Type                   | Description                              |
|-------|------------------------|------------------------------------------|
| …args | number  Array.<number> | one or more numbers or arrays of numbers |

**Returns**: `number`  `Array.<number>`. The range value of all numbers if `args` contains only numbers. Returns an array with the range values at each index, including all scalar numbers in `args` in the calculation at each index if `args` contains at least one array.
**Example**
```js
range(1, 2, 3)
range([10, 20, 30, 40], 15)
range([1, 9], 4, [3, 5])
```


## range( …args )

Finds the range of one of more numbers/arrays of numbers into the function. If at least one array of numbers is passed into the function, the function will find the range by index.

| Param | Type                   | Description                              |
|-------|------------------------|------------------------------------------|
| …args | number  Array.<number> | one or more numbers or arrays of numbers |

**Returns**: `number`  `Array.<number>`. The range value of all numbers if `args` contains only numbers. Returns an array with the the range values at each index, including all scalar numbers in `args` in the calculation at each index if `args` contains at least one array.
**Example**
```js
range(1, 2, 3)
range([10, 20, 30, 40], 15)
range([1, 9], 4, [3, 5])
```


## round( a, b )

Rounds a number towards the nearest integer by default, or decimal place (if passed in as `b`). For arrays, the function will be applied index-wise to each element.

| Param | Type                   | Description                                           |
|-------|------------------------|-------------------------------------------------------|
| a     | number  Array.<number> | a number or an array of numbers                       |
| b     | number                 | (optional) number of decimal places, default value: 0 |

**Returns**: `number`  `Array.<number>`. The rounded value of `a`. Returns an array with the the rounded values of each element if `a` is an array.
**Example**
```js
round(1.2)
round(-10.51)
round(-10.1, 2)
round(10.93745987, 4)
round([2.9234, 5.1234, 3.5234, 4.49234324], 2)
```


## size( a )

Returns the length of an array. Alias for count.

| Param | Type        | Description         |
|-------|-------------|---------------------|
| a     | Array.<any> | array of any values |

**Returns**: `number`. The length of the array.
**Throws**: `'Must pass an array'` if `a` is not an array
**Example**
```js
size([])
size([-1, -2, -3, -4])
size(100)
```


## sqrt( a )

Calculates the square root of a number. For arrays, the function will be applied index-wise to each element.

| Param | Type                   | Description                     |
|-------|------------------------|---------------------------------|
| a     | number  Array.<number> | a number or an array of numbers |

**Returns**: `number`  `Array.<number>`. The square root of `a`. Returns an array with the the square roots of each element if `a` is an array.
**Throws**: `'Unable find the square root of a negative number'` if `a` < 0
**Example**
```js
sqrt(9)
sqrt(30) //5.477225575051661
sqrt([9, 16, 25])
```


## square( a )

Calculates the square of a number. For arrays, the function will be applied index-wise to each element.

| Param | Type                   | Description                     |
|-------|------------------------|---------------------------------|
| a     | number  Array.<number> | a number or an array of numbers |

**Returns**: `number`  `Array.<number>`. The square of `a`. Returns an array with the the squares of each element if `a` is an array.
**Example**
```js
square(-3)
square([3, 4, 5])
```


## subtract( a, b )

Subtracts two numbers. If at least one array of numbers is passed into the function, the function will be applied index-wise to each element.

| Param | Type                   | Description                     |
|-------|------------------------|---------------------------------|
| a     | number  Array.<number> | a number or an array of numbers |
| b     | number  Array.<number> | a number or an array of numbers |

**Returns**: `number`  `Array.<number>`. The difference of `a` and `b` if both are numbers, or an array of differences applied index-wise to each element.
**Throws**: `'Array length mismatch'` if `a` and `b` are arrays with different lengths
**Example**
```js
subtract(6, 3)
subtract([10, 20, 30, 40], 10)
subtract(10, [1, 2, 5, 10])
subtract([14, 42, 65, 108], [2, 7, 5, 12])
```


## sum( …args )

Calculates the sum of one or more numbers/arrays passed into the function. If at least one array is passed, the function will sum up one or more numbers/arrays of numbers and distinct values of an array. Sum accepts arrays of different lengths.
**Returns**: `number`. The sum of one or more numbers/arrays of numbers including distinct values in arrays
**Example**
```js
sum(1, 2, 3)
sum([10, 20, 30, 40], 10, 20, 30)
sum([1, 2], 3, [4, 5], 6)
sum([10, 20, 30, 40], 10, [1, 2, 3], 22)
```


## unique( a )

Counts the number of unique values in an array.
**Returns**: `number`. The number of unique values in the array. Returns 1 if `a` is not an array.
**Example**
```js
unique(100)
unique([])
unique([1, 2, 3, 4])
unique([1, 2, 3, 4, 2, 2, 2, 3, 4, 2, 4, 5, 2, 1, 4, 2])
```