﻿---
title: Panels and visualizations
description: Kibana provides many options to create panels with visualizations of your data and add content to your dashboards. From advanced charts, maps, and metrics...
url: https://www.elastic.co/docs/explore-analyze/visualize
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Panels and visualizations
Kibana provides many options to create panels with visualizations of your data and add content to your dashboards. From advanced charts, maps, and metrics to plain text and images, multiple types of panels with different capabilities are available.
Use one of the editors to create visualizations of your data. Each editor offers various capabilities.


| **Content**                    | **Panel type**                                                                                                                    | **Description**                                                                                                                                                                                                                                       |
|--------------------------------|-----------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Visualizations                 | [Lens](https://www.elastic.co/docs/explore-analyze/visualize/lens)                                                                | Create powerful [charts](https://www.elastic.co/docs/explore-analyze/visualize/supported-chart-types) in Kibana. This is the default editor.                                                                                                          |
|                                | [ES|QL](https://www.elastic.co/docs/explore-analyze/query-filter/languages/esql-kibana)                                           | Create visualizations from ES|QL queries                                                                                                                                                                                                              |
|                                | [Maps](https://www.elastic.co/docs/explore-analyze/visualize/maps)                                                                | Create beautiful displays of your geographical data                                                                                                                                                                                                   |
|                                | [Alerts](https://www.elastic.co/docs/explore-analyze/visualize/alert-panels)                                                      | View Observability or Security alerts in your dashboard                                                                                                                                                                                               |
|                                | [Custom visualizations](https://www.elastic.co/docs/explore-analyze/visualize/custom-visualizations-with-vega)                    | Use Vega to create new types of visualizations                                                                                                                                                                                                        |
|                                |                                                                                                                                   |                                                                                                                                                                                                                                                       |
| Annotations and navigation     | [Collapsible sections](/docs/explore-analyze/dashboards/arrange-panels#collapsible-sections)                                      | Organize your dashboard into sections that can be collapsed and save loading time                                                                                                                                                                     |
|                                | [Markdown text](https://www.elastic.co/docs/explore-analyze/visualize/text-panels)                                                | Add context to your dashboard with markdown-based **text**                                                                                                                                                                                            |
|                                | [Image](https://www.elastic.co/docs/explore-analyze/visualize/image-panels)                                                       | Personalize your dashboard with custom images                                                                                                                                                                                                         |
|                                | [Links](https://www.elastic.co/docs/explore-analyze/visualize/link-panels)                                                        | Add links to other dashboards or to external websites                                                                                                                                                                                                 |
|                                |                                                                                                                                   |                                                                                                                                                                                                                                                       |
| Machine Learning and Analytics | [Anomaly swim lane](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-ad-view-results)            | Display the results from machine learning anomaly detection jobs                                                                                                                                                                                      |
|                                | [Anomaly chart](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-ad-view-results)                | Display an anomaly chart from the **Anomaly Explorer**                                                                                                                                                                                                |
|                                | [Single metric viewer](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-ad-view-results)         | Display an anomaly chart from the **Single Metric Viewer**                                                                                                                                                                                            |
|                                | [Change point detection](/docs/explore-analyze/machine-learning/machine-learning-in-kibana/xpack-ml-aiops#change-point-detection) | Display a chart to visualize change points in your data                                                                                                                                                                                               |
|                                |                                                                                                                                   |                                                                                                                                                                                                                                                       |
| Observability                  | [SLO overview](https://www.elastic.co/docs/solutions/observability/incident-management/service-level-objectives-slos)             | Visualize a selected SLO’s health, including name, current SLI value, target, and status                                                                                                                                                              |
|                                | [SLO Alerts](https://www.elastic.co/docs/solutions/observability/incident-management/service-level-objectives-slos)               | Visualize one or more SLO alerts, including status, rule name, duration, and reason. In addition, configure and update alerts, or create cases directly from the panel.                                                                               |
|                                | [SLO Error Budget](https://www.elastic.co/docs/solutions/observability/incident-management/service-level-objectives-slos)         | Visualize the consumption of your SLO’s error budget                                                                                                                                                                                                  |
|                                |                                                                                                                                   |                                                                                                                                                                                                                                                       |
| Legacy                         | [Aggregation based](https://www.elastic.co/docs/explore-analyze/visualize/legacy-editors/aggregation-based)                       | Create visualizations including area, line, and pie charts and split them up to three aggregation levels. While these panel types are still available, we recommend using [Lens](https://www.elastic.co/docs/explore-analyze/visualize/lens) instead. |
|                                | [TSVB](https://www.elastic.co/docs/explore-analyze/visualize/legacy-editors/tsvb)                                                 | Visualize time-based data through various panel types                                                                                                                                                                                                 |

<note>
  Legacy panel types only appear in the **Add panel** dashboard menu if you already have such panels in your dashboards. If you have never used these panel types, use Lens instead.
</note>