﻿---
title: Transforms API quick reference
description: All transform endpoints have the following base: Create transforms, Delete transforms, Get transforms, Get transforms statistics, Preview transforms,...
url: https://www.elastic.co/docs/explore-analyze/transforms/transform-api-quickref
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Transforms API quick reference
All transform endpoints have the following base:
```js
_transform/
```

- [Create transforms](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-transform-put-transform)
- [Delete transforms](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-transform-delete-transform)
- [Get transforms](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-transform-get-transform)
- [Get transforms statistics](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-transform-get-transform-stats)
- [Preview transforms](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-transform-preview-transform)
- [Reset transforms](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-transform-reset-transform)
- [Schedule now transforms](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-transform-schedule-now-transform)
- [Start transforms](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-transform-start-transform)
- [Stop transforms](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-transform-stop-transform)
- [Update transforms](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-transform-update-transform)

For the full list, see [*Transform APIs*](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-transform).