﻿---
title: Transforming data
description: Transforms enable you to convert existing Elasticsearch indices into summarized indices, which provide opportunities for new insights and analytics. For...
url: https://www.elastic.co/docs/explore-analyze/transforms
products:
  - Elastic Cloud Serverless
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Transforming data
Transforms enable you to convert existing Elasticsearch indices into summarized indices, which provide opportunities for new insights and analytics. For example, you can use transforms to pivot your data into entity-centric indices that summarize the behavior of users or sessions or other entities in your data. Or you can use transforms to find the latest document among all the documents that have a certain unique key.
- [Overview](https://www.elastic.co/docs/explore-analyze/transforms/transform-overview)
- [Setup](https://www.elastic.co/docs/explore-analyze/transforms/transform-setup)
- [When to use transforms](https://www.elastic.co/docs/explore-analyze/transforms/transform-usage)
- [Generating alerts for transforms](https://www.elastic.co/docs/explore-analyze/transforms/transform-alerts)
- [Transforms at scale](https://www.elastic.co/docs/explore-analyze/transforms/transform-scale)
- [How checkpoints work](https://www.elastic.co/docs/explore-analyze/transforms/transform-checkpoints)
- [API quick reference](https://www.elastic.co/docs/explore-analyze/transforms/transform-api-quickref)
- [Tutorial: Transforming the eCommerce sample data](https://www.elastic.co/docs/explore-analyze/transforms/ecommerce-transforms)
- [Examples](https://www.elastic.co/docs/explore-analyze/transforms/transform-examples)
- [Painless examples](https://www.elastic.co/docs/explore-analyze/transforms/transform-painless-examples)
- [Troubleshooting transforms](https://www.elastic.co/docs/troubleshoot/elasticsearch/transform-troubleshooting)
- [Limitations](https://www.elastic.co/docs/explore-analyze/transforms/transform-limitations)