﻿---
title: Debug Painless scripts in Elasticsearch
description: Use the topics in this section to debug common errors in your Painless scripts. Array/list manipulation errors, Date math errors, Field not found (mapping...
url: https://www.elastic.co/docs/explore-analyze/scripting/painless-debugging
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Debug Painless scripts in Elasticsearch
Use the topics in this section to debug common errors in your [Painless](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-painless) scripts.
- [Array/list manipulation errors](https://www.elastic.co/docs/explore-analyze/scripting/painless-array-list-manipulation-errors)
- [Date math errors](https://www.elastic.co/docs/explore-analyze/scripting/painless-date-math-errors)
- [Field not found (mapping conflicts)](https://www.elastic.co/docs/explore-analyze/scripting/painless-field-not-found)
- [Ingest pipeline failures](https://www.elastic.co/docs/explore-analyze/scripting/painless-ingest-pipeline-failures)
- [Null pointer exceptions](https://www.elastic.co/docs/explore-analyze/scripting/painless-null-pointer-exceptions)
- [Regex pattern matching failures](https://www.elastic.co/docs/explore-analyze/scripting/painless-regex-pattern-matching-failures)
- [Runtime field exceptions](https://www.elastic.co/docs/explore-analyze/scripting/painless-runtime-field-exceptions)
- [Sandbox limitations](https://www.elastic.co/docs/explore-analyze/scripting/painless-sandbox-limitations)
- [Script score calculation errors](https://www.elastic.co/docs/explore-analyze/scripting/painless-script-score-calculation-errors)
- [Subfield access](https://www.elastic.co/docs/explore-analyze/scripting/painless-subfield-access)
- [Type casting issues](https://www.elastic.co/docs/explore-analyze/scripting/painless-type-casting-issues)


## Additional resources

- [A Brief Painless walkthrough](https://www.elastic.co/docs/reference/scripting-languages/painless/brief-painless-walkthrough)