﻿---
title: Debug date math errors in Painless
description: When you work with date fields in runtime mappings, accessing methods directly on the document field object can cause errors if the proper value accessor...
url: https://www.elastic.co/docs/explore-analyze/scripting/painless-date-math-errors
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Debug date math errors in Painless
When you work with date fields in runtime mappings, accessing methods directly on the document field object can cause errors if the proper value accessor is not used.
Follow these guidelines to avoid [date](https://www.elastic.co/docs/reference/scripting-languages/painless/using-datetime-in-painless) operation errors in your Painless scripts:
- Always use `.value` when accessing single values from document fields in Painless.
- Check for empty fields when the field might not exist in all documents.
- Date arithmetic should be performed on the actual date value, not the field container object.

For details, refer to the following sample error and solution.

## Sample error

```json
{
  "error": {
    "root_cause": [
      {
        "type": "script_exception",
        "reason": "runtime error",
        "script_stack": [
          """emit(orderDate.toInstant().toEpochMilli() + 14400000);
        """,
          "              ^---- HERE"
        ],
        "script": " ...",
        "lang": "painless",
        "position": {
          "offset": 75,
          "start": 61,
          "end": 124
        }
      }
    ],
    "type": "search_phase_execution_exception",
    "reason": "all shards failed",
    "phase": "query",
    "grouped": true,
    "failed_shards": [
      {
        "shard": 0,
        "index": "kibana_sample_data_ecommerce",
        "node": "CxMTEjvKSEC0k0aTr4OM3A",
        "reason": {
          "type": "script_exception",
          "reason": "runtime error",
          "script_stack": [
            """emit(orderDate.toInstant().toEpochMilli() + 14400000);
        """,
            "              ^---- HERE"
          ],
          "script": " ...",
          "lang": "painless",
          "position": {
            "offset": 75,
            "start": 61,
            "end": 124
          },
          "caused_by": {
            "type": "illegal_argument_exception",
            "reason": "dynamic method [org.elasticsearch.index.fielddata.ScriptDocValues.Dates, toInstant/0] not found"
          }
        }
      }
    ]
  },
  "status": 400
}
```


## Problematic code

```json
"script": {
  "lang": "painless",
  "source": """
    def orderDate = doc['order_date'];
    emit(orderDate.toInstant().toEpochMilli() + 14400000);
  """
}
```


## Root cause

The script attempts to call `toInstant()` directly on a `ScriptDocValues.Dates` object. Date fields in Painless require accessing the `.value` property to get the actual date value before calling date methods.

## Solution

Access the date value using `.value` before calling date methods:
```json
"script": {
  "lang": "painless",
  "source": """
    def orderDate = doc['order_date'].value;
    emit(orderDate.toInstant().toEpochMilli() + 14400000);
  """
}
```