﻿---
title: Write your first script
description: Painless is the default scripting language for Elasticsearch. It is secure, performant, and provides a natural syntax for anyone with a little coding...
url: https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-write-first-script
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Write your first script
[Painless](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-painless) is the default scripting language for Elasticsearch. It is secure, performant, and provides a natural syntax for anyone with a little coding experience.
A Painless script is structured as one or more statements and optionally has one or more user-defined functions at the beginning. A script must always have at least one statement.
The [Painless execute API](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-api-examples) provides the ability to test a script with simple user-defined parameters and receive a result. Let’s start with a complete script and review its constituent parts.
1. Index a document
   Index a document with a single field so that we have some data to work with:
   ```json

   {
     "my_field": 5
   }
   ```
2. Operate on a field
   You can now construct a script that operates on that field and then evaluate the script as part of a query. The following query uses the [`script_fields`](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrieve-selected-fields#script-fields) parameter of the search API to retrieve a script valuation.
   The components of this script are detailed in later pages. For now, note that the script takes `my_field` as input and operates on it.
   ```json

   {
     "script_fields": {
       "my_doubled_field": {
         "script": { <1>
           "source": "doc['my_field'].value * params['multiplier']", <2>
           "params": {
             "multiplier": 2
           }
         }
       }
     }
   }
   ```
   The `script` is a standard JSON object that defines scripts under most APIs in Elasticsearch. This object requires `source` to define the script itself. Since `script` isn't set, the [scripting language](https://www.elastic.co/docs/explore-analyze/scripting) is interpreted as being Painless, by default.