﻿---
title: How to write Painless scripts
description: Wherever scripting is supported in the Elasticsearch APIs, the syntax follows the same pattern; you specify the language of your script, provide the script...
url: https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-using
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# How to write Painless scripts
<tip>
  This guide provides a beginner-friendly introduction to Painless scripting with step-by-step tutorials and practical examples. If you're new to scripting or Painless, this is the recommended starting point.For users with Java or Painless experience looking for technical specifications and advanced features, refer to [A Brief Painless walkthrough](https://www.elastic.co/docs/reference/scripting-languages/painless/brief-painless-walkthrough) in the Reference section.
</tip>

Wherever scripting is supported in the Elasticsearch APIs, the syntax follows the same pattern; you specify the language of your script, provide the script logic (or source), and add parameters that are passed into the script:
```js
  "script": {
    "lang":   "...",
    "source" | "id": "...",
    "params": { ... }
  }
```

<definitions>
  <definition term="lang">
    Specifies the language the script is written in. Defaults to `painless`.
  </definition>
  <definition term="source, id">
    The script itself, which you specify as `source` for an inline script or `id` for a stored script. Use the [stored script APIs](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-script) to create and manage stored scripts.
  </definition>
  <definition term="params">
    Specifies any named parameters that are passed into the script as variables. [Use parameters](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-use-parameters) instead of hard-coded values to decrease compile time.
  </definition>
</definitions>

Get started with Painless scripting:
- [Write your first script](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-write-first-script)
- [Use parameters in your script](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-use-parameters)
- [Shorten your script](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-shorten-script)
- [Store and retrieve scripts](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-store-and-retrieve)
- [Update documents using scripts](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-update-documents)