﻿---
title: Store and retrieve scripts
description: You can store and retrieve scripts from the cluster state using the stored script APIs. Stored scripts allow you to reference shared scripts for operations...
url: https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-store-and-retrieve
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Store and retrieve scripts
You can store and retrieve scripts from the cluster state using the [stored script APIs](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-script). Stored scripts allow you to reference shared scripts for operations like scoring, aggregating, filtering, and reindexing. Instead of embedding scripts inline in each query, you can reference these shared operations.
Stored scripts can also reduce request payload size. Depending on script size and request frequency, this can help lower latency and data transfer costs.
<note>
  Unlike regular scripts, stored scripts require that you specify a script language using the `lang` parameter.
</note>

To create a script, use the [create stored script API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-put-script). For example, the following request creates a stored script named `calculate-score`.
```json

{
  "script": {
    "lang": "painless",
    "source": "Math.log(_score * 2) + params['my_modifier']"
  }
}
```

You can retrieve that script by using the [get stored script API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-get-script).
```json
```

To use the stored script in a query, include the script `id` in the `script` declaration:
```json

{
  "query": {
    "script_score": {
      "query": {
        "match": {
            "message": "some message"
        }
      },
      "script": {
        "id": "calculate-score", <1>
        "params": {
          "my_modifier": 2
        }
      }
    }
  }
}
```

To delete a stored script, submit a [delete stored script API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-delete-script) request.
```json
```