﻿---
title: Shorten your script
description: Using syntactic abilities that are native to Painless, you can reduce verbosity in your scripts and make them shorter. Here’s a simple script that we...
url: https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-shorten-script
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Shorten your script
Using syntactic abilities that are native to Painless, you can reduce verbosity in your scripts and make them shorter. Here’s a simple script that we can make shorter:
```json

{
  "script_fields": {
    "my_doubled_field": {
      "script": {
        "lang":   "painless",
        "source": "return doc['my_field'].value * params.get('multiplier');",
        "params": {
          "multiplier": 2
        }
      }
    }
  }
}
```

Let’s look at a shortened version of the script to see what improvements it includes over the previous iteration:
```json

{
  "script_fields": {
    "my_doubled_field": {
      "script": {
        "source": "field('my_field').get(null) * params['multiplier']",
        "params": {
          "multiplier": 2
        }
      }
    }
  }
}
```

This version of the script removes several components and simplifies the syntax significantly:
- The `lang` declaration. Because Painless is the default language, you don’t need to specify the language if you’re writing a Painless script.
- The `return` keyword. Painless automatically uses the final statement in a script (when possible) to produce a return value in a script context that requires one.
- The `get` method, which is replaced with brackets `[]`. Painless uses a shortcut specifically for the `Map` type that allows us to use brackets instead of the lengthier `get` method.
- The semicolon at the end of the `source` statement. Painless does not require semicolons for the final statement of a block. However, it does require them in other cases to remove ambiguity.

You can use this abbreviated syntax anywhere that Elasticsearch supports scripts, such as when you’re creating [runtime fields](https://www.elastic.co/docs/manage-data/data-store/mapping/map-runtime-field). Be mindful, however, that the `field` access API is not a direct replacement for `doc`. This shortened version of the original script includes a default value (the `null`), so depending on the field type the script may access either `doc` values or `_source`. Some fields will use `_source` as a fallback if `doc` values aren't available for a specific field.