﻿---
title: Introduction to Painless
description: Painless is a secure, performant, and flexible scripting language designed specifically for Elasticsearch. As the default scripting language for Elasticsearch,...
url: https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-painless
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Introduction to Painless
<tip>
  This introduction is designed for users new to Painless scripting. If you're already familiar with Painless, refer to the [Painless language specification](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-language-specification) for syntax details and advanced features.
</tip>

Painless is a secure, performant, and flexible scripting language designed specifically for Elasticsearch. As the default scripting language for Elasticsearch, Painless lets you safely customize search behavior, data processing, and operations workflows across your Elastic Stack deployments.

## What is Painless?

Painless was introduced in [Elasticsearch 5.0](https://www.elastic.co/blog/painless-a-new-scripting-language) as a replacement for Groovy, with improved security and performance compared to previous scripting solutions. Built on the [Java Virtual Machine (JVM)](https://docs.oracle.com/en/java/javase/24/vm/java-virtual-machine-technology-overview.html), Painless provides the familiar syntax of Java while improving the security boundaries with guardrails and a sandbox environment.
Unlike general scripting languages, Painless is purpose-built for Elasticsearch, enabling native performance while preventing unauthorized access to system resources. This architecture makes Painless both powerful for data manipulation and safe for production environments.
Common use cases include creating new fields based on existing data, calculating time differences between dates, extracting structured data from log messages, and implementing custom business logic in search scoring. For more examples, refer to our step-by-step [tutorials](https://www.elastic.co/docs/explore-analyze/scripting/common-script-uses).

## Benefits

Painless enables scripting in various contexts throughout Elasticsearch, such as:

### Search enhancement

- Custom search scoring based on business requirements
- Runtime field creation that calculates values during query execution
- Real-time filtering and transformation without reindexing data


### Data processing

- Transform documents during indexing
- Parse and extract structured data from unstructured fields
- Calculate metrics and summaries from your data


### Operational automation

- Monitor data patterns and trigger alerts with Watcher solutions
- Transform alert payloads for targeted notifications and actions


## How it works

You can write Painless scripts inline for quick operations or create reusable functions for your data operation. Here’s a sample Painless script applied to data transformation:
```java
String productTitle(String manufacturer, String productName) {
  return manufacturer + " - " + productName;
}

return productTitle("Elitelligence", "Winter jacket");
```

This script demonstrates a few facets of Painless scripting:
- **Function definition:** Custom `productTitle` function with typed parameters
- **Data types:** String and integer parameter handling
- **Return values:** Function returns formatted string output

Painless provides three core benefits across all scripting contexts:
- **Security:** Fine-grained allowlists that prevent access to restricted Java APIs.
- **Performance**: Direct compilation to [bytecode](https://docs.oracle.com/javase/specs/jvms/se7/html/jvms-6.html) eliminates interpretation overhead and leverages JVM optimization.
- **Flexibility**: Wide range of scripting syntax and contexts across Elasticsearch, from search scoring to data processing to operational processing.


## Where to write in Painless

You can use Painless in multiple contexts throughout Elasticsearch:
- [**Dev Tools Console**](https://www.elastic.co/docs/explore-analyze/query-filter/tools/console)**:** for interactive script development and testing
- [**Ingest pipelines**](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines)**:** for data transformation during indexing
- [**Search queries**](https://www.elastic.co/docs/solutions/search)**:** for custom scoring and script fields
- [**Runtime fields**](https://www.elastic.co/docs/manage-data/data-store/mapping/runtime-fields)**:** for dynamic field creation
- [**Update API:**](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-update) for document modification
- [**Watcher**](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher)**:** for alert conditions and actions


## Start scripting

Write your first Painless script by trying out our [guide](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-using) or jump into one of our [tutorials](https://www.elastic.co/docs/explore-analyze/scripting/common-script-uses) for real-world examples using sample data.
For complete syntax and language features, refer to the [Painless language specification](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-language-specification).
Once you get started, refer to [Debug Painless scripts in Elasticsearch](https://www.elastic.co/docs/explore-analyze/scripting/painless-debugging) for helpful tips about how to resolve common scripting errors.