﻿---
title: Painless script tutorials
description: You can write a script to do almost anything, and sometimes, that’s the challenge. It’s difficult to know what’s possible with scripts, so these tutorials...
url: https://www.elastic.co/docs/explore-analyze/scripting/common-script-uses
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Painless script tutorials
You can write a script to do almost anything, and sometimes, that’s the challenge. It’s difficult to know what’s possible with scripts, so these tutorials address common use cases where scripts are particularly helpful.
Painless scripting becomes powerful when applied to real-world scenarios. These tutorials walk you through essential patterns and operations, providing working examples you can modify for your specific use cases.
- [Accessing document fields and special variables](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-fields)
- [Accessing fields in a document](https://www.elastic.co/docs/explore-analyze/scripting/script-fields-api)
- [Converting data types](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-type-casting-tutorial)
- [Dissecting data](https://www.elastic.co/docs/explore-analyze/scripting/dissect)
- [Extracting fields](https://www.elastic.co/docs/explore-analyze/scripting/scripting-field-extraction)
- [Grokking grok](https://www.elastic.co/docs/explore-analyze/scripting/grok)
- [Scripts, caching, and search speed](https://www.elastic.co/docs/explore-analyze/scripting/scripts-search-speed)
- [Updating documents](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-document-update-tutorial)
- [Using Painless regular expressions](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-regular-expressions-tutorial)
- [Working with dates](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-datetime-tutorial)