﻿---
title: Query tools
description: Access these specialized tools in Kibana and the Serverless UI to develop, debug, and refine your search queries while monitoring their performance and...
url: https://www.elastic.co/docs/explore-analyze/query-filter/tools
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Query tools
Access these specialized tools in Kibana and the Serverless UI to develop, debug, and refine your search queries while monitoring their performance and efficiency.

| Tool                                                                                              | Function                                                                                                                                           |
|---------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------|
| [Saved queries](https://www.elastic.co/docs/explore-analyze/query-filter/tools/saved-queries)     | Save your searches and queries to reuse them later.                                                                                                |
| [Console](https://www.elastic.co/docs/explore-analyze/query-filter/tools/console)                 | Interact with the REST APIs of Elasticsearch and Kibana, including sending requests and viewing API documentation.                                 |
| [Search Profiler](https://www.elastic.co/docs/explore-analyze/query-filter/tools/search-profiler) | Inspect and analyze your search queries.                                                                                                           |
| [Grok Debugger](https://www.elastic.co/docs/explore-analyze/query-filter/tools/grok-debugger)     | Build and debug grok patterns before you use them in your data processing pipelines.                                                               |
| [Painless Lab](https://www.elastic.co/docs/explore-analyze/scripting/painless-lab)                | <applies-to>Elastic Stack: Beta</applies-to> <applies-to>Elastic Cloud Serverless: Beta</applies-to> Test and debug Painless scripts in real-time. |
| [Playground](https://www.elastic.co/docs/explore-analyze/query-filter/tools/playground)           | Combine your Elasticsearch data with the power of large language models (LLMs) for retrieval augmented generation (RAG), using a chat interface.   |